<?php

namespace Modules\Reports\Controllers;

use Illuminate\Http\Request;
use Modules\Reports\Controllers\Controller;
use Module;
use DB;
use App\Helpers\DBConnect;
use Modules\Reports\Models\Order;

class OrderController extends Controller
{
    static $connection;
    protected $locales;

    public static function table($table) {
        if (self::$connection) {
            return self::$connection->table($table);
        } else {
            return DB::table($table);
        }
    }

    public static function setConnection($locale) {
        $connection = DBconnect::connect($locale);
        self::$connection = $connection;
    }

    public function index(Request $request)
    {
        $locates = getModuleLocale();
        $marketEnableds = [];
        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }
        $categories = self::table('category')
            ->pluck('name', 'id');
        return view('reports::order.index', ['locates' => $this->locales, 'categories' => $categories]);
    }

    public function findOrderRefund(Request $request) {
        $filter = $this->buildFilter($request);
        $totalOrders = $this->getCountTotalOrders($filter);

        $orderRefund = self::table('order')
            ->where("payment_status", "PAID")
            ->where('created_at', '>=', $filter['from_date'])
            ->where('created_at', '<=', $filter['to_date'])
            ->where(function($q) {
                $q->whereNull("return_fee");
                $q->orWhere("return_fee", "<>", 0);
            })
            ->groupBy("return_reason")
            ->get(["return_reason", \DB::raw("COUNT(*) as total"), \DB::raw("SUM(return_fee) as total_return_fee")]);
        $response = [
            "status" => "successful",
            "result" => [
                "totalOrders" => $totalOrders,
                "orderRefund" => $orderRefund
            ]
        ];
        return response()->json($response);
    }

    private function getCountTotalOrders($filter)
    {
        $query = self::table('order')
            ->where("payment_status", "PAID")
            ->whereNull("parent_id")
            ->where('created_at', '>=', $filter['from_date'])
            ->where('created_at', '<=', $filter['to_date']);
        return $query->count();

    }

    private function buildFilter($request)
    {
        $retVal = [];
        if ($request->has('locale')) {
            $this->setConnection($request->get('locale'));
        }
        $currentDate = new \DateTime();
        $retVal['from_date'] = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $retVal['to_date'] = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $retVal['query_from'] = $retVal['from_date']->setTime(0, 0, 0);
        $retVal['query_to'] = $retVal['to_date']->setTime(23,59,59);
        return $retVal;
    }
}
