<?php

namespace Modules\Reports\Controllers;

use Modules\Reports\Controllers\Controller;
use Illuminate\Http\Request;

class PredictController extends Controller
{

    public function indexProductHasSale (Request $request)
    {
        return view('reports::predict.product-has-sale.index');
    }

    public function getPredictReport(Request $request) {
        $correctData = $this->getCorrectPatio($request);
        $daysToSaleData = $this->getSalesDate($request);
        $predictData = $this->getPredictHasSaleRatio($request);
        return response()->json([
            'result' => [
                'correct_data' => $correctData,
                'days_to_sale_data' => $daysToSaleData,
                'predict_data' => $predictData
            ],
            'status' => 'successful'
        ]);
    }

    private function getCorrectPatio($request) {
        $totalPredictedSales = \DB::table('ai_dataset_estimate')
                            ->where('estimate', 1)
                            ->pluck('product_id')->unique()->count();
        $totalHadSale = \DB::table('ai_dataset_estimate')
                            ->where('estimate', 1)
                            ->where('total_sale', '>', 0)
                            ->pluck('product_id')->unique()->count();
        $percentRight = 0;
        if ($totalPredictedSales > 0) {
            $percentRight = round($totalHadSale / $totalPredictedSales * 100, 2);
        }

        return [
            'total_predicted_sales' => $totalPredictedSales,
            'total_had_sale' => $totalHadSale,
            'percent_right' => $percentRight
        ];
    }

    private function getSalesDate($request)
    {
        $avgDaysToSale = \DB::table('ai_dataset_estimate')
                            ->where('estimate', 1)
                            ->where('total_sale', '>', 0)
                            ->pluck('days_to_sale')->avg();
        
        return [
            'avg_days_to_sale' => round($avgDaysToSale, 0)
        ];
    }

    private function getPredictHasSaleRatio($request) {
        $totalPredicted = \DB::table('ai_dataset_estimate')
                            ->pluck('product_id')->unique()->count();
        $totalHadSale = \DB::table('ai_dataset_estimate')
                            ->where('estimate', 1)
                            ->pluck('product_id')->unique()->count();
        $percentHasSale = 0;
        if ($totalPredicted > 0) {
            $percentHasSale = round($totalHadSale / $totalPredicted * 100, 2);
        }

        return [
            'total_predicted' => $totalPredicted,
            'total_sale' => $totalHadSale,
            'percent_right' => $percentHasSale
        ];
    }

    public function getSaleData(Request $request) {

        $query = \DB::table('ai_dataset_estimate as ade');

        if ($request->has('estimate_result')) {
            $query->where('ade.estimate', $request->estimate_result);
        }

        if ($request->has('date_from')) {
            $dateFrom = date('Y-m-d', strtotime($request->date_from));
            $query->where('ade.estimate_date', '>=', $request->date_from);
        }

        if ($request->has('date_to') && $request->date_to != '') {
            $dateTo = date('Y-m-d', strtotime($request->date_to));
            $query->where('ade.estimate_date', '<=', $request->date_to);
        }

        if ($request->has('product_id') && $request->product_id != '') {
            $query->where('ade.product_id', $request->product_id);
        }

        $totalQuery = clone $query;

        $query->join('product as p', 'ade.product_id', '=', 'p.id');


        $pageId = $request->has('page_id') ? $request->page_id : 0;
        $pageSize = $request->has('page_size') ? $request->page_size : 100;
        $query->select('ade.id', 'ade.estimate_date', 'ade.estimate', 'p.sku', 'p.name', 'ade.product_id', 'p.image_url', 'ade.total_sale', 'ade.earliest_sale_date', 'ade.score')
                    ->orderBy('ade.estimate_date', 'desc')->orderBy('ade.score', 'desc');

        $items = $query->offset($pageId * $pageSize)->limit($pageSize)->get();
        $total = $totalQuery->count();

        $pagination = [
            'page' => $pageId,
            'page_size' => $pageSize,
            'total' => $total,
            'total_page' => ceil($total / $pageSize),
        ];
        
        return response()->json([
            'items' => $items,
            'total' => $totalQuery->count(),
            'meta' => $pagination,
            'status' => 'successful'
        ]);
    }
 
}
