<?php

namespace Modules\Reports\Controllers;

use Illuminate\Http\Request;
use Modules\Reports\Controllers\Controller;
use Module;
use DB;
use App\Helpers\DBConnect;

class ProductController extends Controller
{
    static $connection;
    protected $locales;

    public static function table($table) {
        if (self::$connection) {
            return self::$connection->table($table);
        } else {
            return DB::table($table);
        }
    }

    public static function setConnection($locale) {
        $connection = DBconnect::connect($locale);
        self::$connection = $connection;
    }

    public function sourceIndex (Request $request) {
        $locates = getModuleLocale();
        $marketEnableds = [];
        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }
        $sources = self::table('source')
            ->pluck('name', 'id');
        return view('reports::product-source.index', ['locates' => $this->locales, 'sources' => $sources]);
    }

    public function categoryIndex (Request $request) {
        $locates = getModuleLocale();
        $marketEnableds = [];
        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }
        $categories = self::table('category')
            ->pluck('name', 'id');
        return view('reports::product-category.index', ['locates' => $this->locales, 'categories' => $categories]);
    }
    
    public function getReportProductSource(Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        $filter = $this->buildFilter($request);
        $countProducts = $this->getCountProducts($filter);
        $revenueQuantities = $this->getQuantityAndRevenueAndCost($filter);
        $data = [];
        foreach ($countProducts as $sourceId => $countProduct) {
            $data[$sourceId] = [
                'count_products' => $countProduct,
                'source_id' => $sourceId,
                'revenue' => 0,
                'quantity' => 0,
            ];
        }
        foreach ($revenueQuantities as $revenueQuantity) {
            if (!array_key_exists($revenueQuantity->source_id, $data)) {
                $data[$revenueQuantity->source_id] = ['count_products' => 0];
            }
            $data[$revenueQuantity->source_id]['revenue'] = $revenueQuantity->revenue;
            $data[$revenueQuantity->source_id]['quantity'] = $revenueQuantity->quantity;
            $data[$revenueQuantity->source_id]['ads_cost'] = $revenueQuantity->ads_cost;
            $data[$revenueQuantity->source_id]['cost'] = $revenueQuantity->cost;
        }
        if ($revenueQuantities) {
            $retVal['result'] = $data;
        }
        $retVal['status'] = 'successful';
        return $retVal;
    }

    public function getReportProductCategory(Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        $filter = $this->buildFilter($request);
        $countProducts = $this->getCountProducts($filter);
        $countProductSoldsCategory = $this->getCountProductSoldsCategory($filter);
        $revenueQuantities = $this->getQuantityAndRevenueAndCost($filter);
        foreach ($revenueQuantities as $revenueQuantity) {
            $revenueQuantity->count_products = 0;
            $revenueQuantity->count_productSolds = 0;
            
            if(isset($countProducts[$revenueQuantity->category_id])) {
                $revenueQuantity->count_products = $countProducts[$revenueQuantity->category_id];
            }
            if(isset($countProductSoldsCategory[$revenueQuantity->category_id])) {
                $revenueQuantity->count_productSolds = $countProductSoldsCategory[$revenueQuantity->category_id];
            }
            $revenueQuantity->profit = $revenueQuantity->revenue - $revenueQuantity->cost;
        }
        if ($revenueQuantities) {
            $retVal['result'] = $revenueQuantities;
        }
        $retVal['status'] = 'successful';
        return $retVal;
    }

    private function getCountProducts($filter)
    {
        $query = self::table('summary_product_date')
            ->where('date', '>=', $filter['from_date'])
            ->where('date', '<=', $filter['to_date']);
        if (isset($filter['source_id']) && $filter['source_id']) {
            $query->where('source_id', $filter['source_id']);
        }
        if (isset($filter['category_id']) && $filter['category_id']) {
            $query->where('category_id', $filter['category_id']);
        }
        if ($filter['group_by'] == 'source_id') {
            $query->select(DB::raw('SUM(count_products) as count_products'), 'source_id')
                ->groupBy('source_id');
        } else {
            $query->select(DB::raw('SUM(count_products) as count_products'), 'category_id')
                ->groupBy('category_id');
        }
        return $query->pluck('count_products', $filter['group_by']);

    }
    private function getCountProductSoldsCategory($filter)
    {

        $retVal = [];
        $productCategories = self::table('order')
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->join('product_n_category as pnc', 'pnc.product_id', '=', 'oi.product_id')
            ->where('pnc.is_parent', 0)
            ->where('order.created_at', '>=', $filter['from_date'])
            ->where('order.created_at', '<=', $filter['to_date'])
            ->select('oi.product_id', 'pnc.category_id')
            ->groupBy('category_id', 'oi.product_id')->get();
        foreach ($productCategories as $product) {
            if (!array_key_exists($product->category_id, $retVal)) {
                $retVal[$product->category_id] = 0;
            }
            $retVal[$product->category_id] += 1;
        }
        return $retVal;

    }
    private function getQuantityAndRevenueAndCost($filter)
    {
        $query = self::table('summary_order_date')
                    ->where('date', '>=', $filter['from_date'])
                    ->where('date', '<=', $filter['to_date']);
        if (isset($filter['source_id']) && $filter['source_id']) {
            $query->where('source_id', $filter['source_id']);
        }
        if (isset($filter['category_id']) && $filter['category_id']) {
            $query->where('category_id', $filter['category_id']);
        }
        if (isset($filter['orders']) && count($filter['orders']) > 0) {
            foreach ($filter['orders'] as $key => $value) {
                $query->orderBy($key, $value);
            }
        }
        if ($filter['group_by'] == 'source_id') {
            $query->select(
                DB::raw('SUM(revenue) as revenue'),
                DB::raw('SUM(quantity) as quantity'),
                DB::raw('SUM(ads_cost) as ads_cost'),
                DB::raw('SUM(cost) as cost'),
                'source_id'
            )
                ->groupBy('source_id');
        } else {
            $query->select(
                DB::raw('SUM(revenue) as revenue'),
                DB::raw('SUM(quantity) as quantity'),
                DB::raw('SUM(ads_cost) as ads_cost'),
                DB::raw('SUM(cost) as cost'),
                'category_id'
            )
                ->groupBy('category_id');
        }
        return $query->get();

    }
    private function buildFilter($request)
    {
        $params = ['source_id', 'category_id'];
        $retVal = [];
        foreach ($params as $param) {
            if ($request->has($param)) {
                $retVal[$param] = $request->get($param);
            }
        }
        if ($request->has('group_by')) {
            $retVal['group_by'] = $request->get('group_by', 'source_id');
        }
        if ($request->has('locale')) {
            $this->setConnection($request->get('locale'));
        }
        $sort = $request->has('sort') ? $request->input('sort') : '';
        if ($sort != '') {
            $retVal['sort'] = $sort;
            $arrOrders = explode('-', $retVal['sort']);
            $retVal['orders'] = [$arrOrders[0] => $arrOrders[1]];
        }
        $currentDate = new \DateTime();
        $retVal['from_date'] = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $retVal['to_date'] = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $retVal['query_from'] = $retVal['from_date']->setTime(0, 0, 0);
        $retVal['query_to'] = $retVal['to_date']->setTime(23,59,59);
        return $retVal;
    }

    public function recentSaleIndex (Request $request) {
        $locates = getModuleLocale();
        $marketEnableds = [];
        foreach ($locates as $locale) {
            if ($locale['enable'] && $locale['locale'] != 'central') {
                $this->locales[$locale['locale']] = $locale['name'];
            }
        }
        $categories = self::table('category')
            ->pluck('name', 'id');
        return view('reports::recent-product-sale.index', ['locates' => $this->locales, 'categories' => $categories]);
    }

    public function getRecentProductHasSale (Request $request)
    {
        $retVal  = [
            'status' => 'fail',
            'result' => []
        ];
        $filter = $this->buildFilter($request);
        $query = self::table('order')
                ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
                ->join('product', 'product.id', '=', 'oi.product_id')
                ->where('order.payment_status', 'PAID')
                ->where('order.created_at', '>=', $filter['query_from'])
                ->where('order.created_at', '<=', $filter['query_to']);
        if (isset($filter['category_id']) && $filter['category_id']) {
            $query->join('product_n_category as pnc', 'pnc.product_id', '=',  'product.id')
                ->where('pnc.category_id', $filter['category_id']);
        }
        $products = $query
            ->groupBy('product.id')
            ->orderBy('sale', 'desc')
            ->get(['product.name', 'product.id', 
            DB::raw('COUNT(sb_oi.product_id) as sale'), 'product.slug',
            'product.created_at']);
        if ($products) {
            $retVal = [
                'status' => 'successful',
                'result' => $products
            ];
        }
        return $retVal;
    }
}
