<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 9/14/21
 * Time: 2:50 PM
 */

namespace Modules\Reports\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Reports\Controllers\Controller;
use Modules\Reports\Models\Order;
use Modules\Reports\Models\OrderWithFulfillment;

class ResendController extends Controller
{
    function index () {
        if (env('APP_LOCALE') != 'central') {
            return response()->json([
                'status' => 'fail',
                'message' => 'Locale Invalid!'
            ], 403);
        }
        return view('reports::resend.index');
    }

    function find (Request $request) {
        $listGroupReason = [
            'fulfill'  => [
                'Wrong Item - Fulfill Team',
                'Late Delivery - Fulfill Team',
                'Return To Sender - Fulfill Team',
                'Low Quality - Fulfill Team',
            ],
            'design' => [
                'Wrong Item - Design Team',
                'Low Quality - Design Team',
                'Late delivery - Design Team',
                'Unwilling Guests - Design team'
            ],
            'print_provider' => [
                'Return To Sender - Print Provider',
                'Order Cancel - Print Provider',
                'Lost Item - Print Provider',
                'Wrong Item - Print Provider',
                'Non-Fitting - Print Provider',
                'Late Delivery - Print Provider',
                'Low Quality - Print Provider',
                'Damage Product - Print Provider',
            ],
            'customer' => [
                'Return To Sender - Customer',
                'Lost item - Customer',
            ],
            'support' => [
                'Wrong Item - Support Team',
                'Lost item - Support Team',
                'Wrong Item - Support Team out',
                'Lost Item - Support Team out',
            ],
            'content' => [
                'Wrong Item - Content Team'
            ],
            'tool' => [
                'Wrong Item - Tool',
                'Return To Sender - Tool',
            ],
            'other' => [
                'Duplicate Order',
                'Refund Tax',
                'Partial Refund',
                'Merge Order',
                'Exchange Product',
                'Unwilling Guests',
                'Unhappy - Product',
                'Unhappy - Shipping time',
            ]
        ];
        $reason = $request->input('reason');
        $type = $request->input('type');
        $currentDate = new \DateTime();
        $fromDate = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $toDate = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $reportFrom = $fromDate->setTime(0, 0, 0);
        $reportTo = $toDate->setTime(23, 59, 59);

        $locales = getModuleLocale();
        $url = 'https://[locale].api.printerval.com/order/get-feedback-issue-data';
        $urls = [];
        $localesByUrl = [];
        foreach ($locales as $localeData) {
            if ($localeData['locale'] == 'central') {
                continue;
            }
            $urlByLocale = str_replace('[locale]', $localeData['locale'], $url);
            $urls[] = $urlByLocale;
            $localesByUrl[$urlByLocale] = $localeData;
        }
        $params = [
            'from_time' => $reportFrom->format('Y-m-d H:i:s'),
            'to_time' => $reportTo->format('Y-m-d H:i:s')
        ];
        if ($request->input('order_code')) {
            $params['order_code'] = $request->input('order_code');
        }
        $dataRequest = $this->multiCurl($urls, $params);
        $data = [];
        $listCode = [];
        $countByReason = [];
        foreach ($dataRequest as $url => $objData) {
            $list = json_decode($objData, true);
            foreach ($list['data'] as $item) {
                $item['type'] = $item['return_reason'] ? 'Refund' : 'Resend';
                if ($reason && (!isset($listGroupReason[$reason]) || !in_array($item['feedback_issue'], $listGroupReason[$reason]))) {
                    continue;
                }
                if ($type && strtolower($type) != strtolower($item['type'])) {
                    continue;
                }
                if (!isset($countByReason[$item['feedback_issue']])) {
                    $countByReason[$item['feedback_issue']] = 0;
                }
                $countByReason[$item['feedback_issue']]++;
                $item['locale_data'] = $localesByUrl[$url];
//                $item['cost'] = round($item['cost'] * (1 / $item['locale_data']['currencyRatio']), 2);
                $item['order_item_id'] = intval($item['order_item_id']);
                $item['cs_email'] = '';
                $item['cs_name'] = '';
                $item['design_email'] = '';
                $item['design_name'] = '';
                $item['feedback_email'] = '';
                $item['feedback_name'] = '';
                $item['note'] = '';
                if (!empty($item['feedback_user_name'])) {
                    $item['feedback_name'] = $item['feedback_user_name'];
                }
                if (!empty($item['feedback_user_email'])) {
                    $item['feedback_email'] = $item['feedback_user_email'];
                }
                if (!$item['feedback_name'] && $item['configurations']) {
                    $configObj = json_decode($item['configurations']);
                    if (!empty($configObj->feedback_user_name)) {
                        $item['feedback_name'] = $configObj->feedback_user_name;
                        $item['feedback_email'] = $configObj->feedback_user_email;
                    }
                }
                $data[] = $item;
                $listCode[] = $item['code'];
            }
        }
        if ($data) {
            usort($data, function($a, $b) {
                return $a['created_at'] >= $b['created_at'];
            });
            $tickets = DB::table('ticket')
                ->leftJoin('users', 'users.id', '=', 'ticket.user_id')
                ->whereIn('ticket.order_code', $listCode)
                ->get(['ticket.order_code', 'users.name', 'users.email']);
            $ticketsByCode = [];
            foreach ($tickets as $item) {
                $ticketsByCode[$item->order_code] = $item;
            }
            $jobsByCode = [];
            $jobs = DB::table('order_n_design_job')
                ->leftJoin('design_job', 'design_job.id', '=', 'order_n_design_job.design_job_id')
                ->leftJoin('users', 'design_job.designer_id', '=', 'users.id')
                ->whereIn('order_n_design_job.order_code', $listCode)
                ->get(['order_n_design_job.order_code', 'order_n_design_job.order_item_id', 'users.name', 'users.email']);
            foreach ($jobs as $item) {
                $jobsByCode[$item->order_code][intval($item->order_item_id)] = $item;
            }

            $comments = DB::table('order_board_comment')
                ->whereIn('order_code', $listCode)
                ->where(function($query) {
                    $query->where('content', 'like', 'issue%');
                    $query->orWhere('content', 'like', ' issue%');
                })
                ->where('source', '=', 'ticket')
                ->get(['content', 'order_code']);

            $commentsByCode = [];
            foreach ($comments as $item) {
                if (!isset($commentsByCode[$item->order_code])) {
                    $commentsByCode[$item->order_code] = [];
                }
                $commentsByCode[$item->order_code][] = $item->content;
            }
            foreach ($data as $key => $item) {
                if (isset($ticketsByCode[$item['code']])) {
                    $data[$key]['cs_email'] = $ticketsByCode[$item['code']]->email;
                    $data[$key]['cs_name'] = $ticketsByCode[$item['code']]->name;
                }
                if (isset($jobsByCode[$item['code']][$item['order_item_id']])) {
                    $data[$key]['design_email'] = $jobsByCode[$item['code']][$item['order_item_id']]->email;
                    $data[$key]['design_name'] = $jobsByCode[$item['code']][$item['order_item_id']]->name;
                }
                if (isset($commentsByCode[$item['code']])) {
                    $data[$key]['note'] = implode(' | ', $commentsByCode[$item['code']]);
                }
            }
        }

        return response()->json([
            'status' => 'successful',
            'data' => $data,
            'countByReason' =>  $countByReason
        ]);
    }

    function endsWith( $haystack, $needle ) {
        $haystack = mb_strtolower($haystack);
        $needle = mb_strtolower($needle);
        $length = strlen( $needle );
        if( !$length ) {
            return true;
        }
        return substr( $haystack, -$length ) === $needle;
    }

    protected function multiCurl($urls = [], $data = [], $method = "GET",$auth = null, $dataByUrl = [])
    {
        ini_set('MAX_EXECUTION_TIME', 300);
        $listChannel = array();
        $mh = curl_multi_init();
        foreach ($urls as $url) {
            if (isset($dataByUrl[$url])) {
                $data = $dataByUrl[$url];
            }
            $ch = curl_init();
            if (!empty($auth)){
                curl_setopt($ch, CURLOPT_USERPWD, $auth);
            }
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
            curl_setopt($ch, CURLOPT_MAXREDIRS, 3);
            curl_setopt($ch, CURLOPT_POSTREDIR, 1);
            if (isset($data['timeout'])) {
                curl_setopt($ch, CURLOPT_TIMEOUT, $data['timeout']);
            } else {
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            }
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
            curl_multi_add_handle($mh, $ch);
            $listChannel[$url] = $ch;
        }
        $index = null;
        $result = [];
        do {
            curl_multi_exec($mh, $index);
        } while ($index > 0);

        foreach ($listChannel as $url => $ch) {
            $result[$url] = curl_multi_getcontent($ch);
            curl_multi_remove_handle($mh, $ch);
        }
        curl_multi_close($mh);
        return $result;
    }
}
