<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 9/14/21
 * Time: 2:50 PM
 */

namespace Modules\Reports\Controllers;


use Illuminate\Http\Request;
use Modules\Reports\Controllers\Controller;
use Modules\Reports\Models\Order;
use Modules\Reports\Models\OrderWithFulfillment;

class VerifierController extends Controller
{
    function index () {
        return view('reports::verifier.index');
    }

    function find (Request $request) {
        $currentDate = new \DateTime();
        $fromDate = $request->has('dateFrom') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateFrom')) : $currentDate;
        $toDate = $request->has('dateTo') ? \DateTime::createFromFormat('d/m/Y', $request->input('dateTo')) : $currentDate;
        $reportFrom = $fromDate->setTime(0, 0, 0);
        $reportTo = $toDate->setTime(23, 59, 59);
        $searchName = $request->input('keyword');
        $query = OrderWithFulfillment::with(['verifierStaff' => function ($q) use ($searchName) {
            if ($searchName) {
                $q->where('name', 'like', '%' . $searchName . '%');
            }
        }])
            ->whereNotNull('verifier_id')
            ->where('verifier_id', '!=', '')
            ->where('created_at', '>=', $reportFrom)
            ->where('created_at', '<=', $reportTo);
        $orders = $query->get(['id', 'verifier_id', 'status', 'cost', 'amount', 'return_reason', 'created_at']);
        $data = [];
        foreach ($orders as $order) {
            if(!$order->verifierStaff) {
                continue;
            }
            $key = $order->verifierStaff->email;
            if (!isset($data[$key])) {
                $data[$key] = [
                    'totalOrder' => 0,
                    'cancelOrder' => 0,
                    'returnOrder' => 0,
                    'totalAmount' => 0,
                    'totalCost' => 0,
                    'totalFulfillmentTime' => 0,
                    'countFulfillmentTime' => 0,
                    'successOrder' => 0,
                    'processingOrder' => 0,
                    'name' => $order->verifierStaff->name,
                    'returnDetail' => [],
                    'cancelDetail' => [],
                ];
            }
            $data[$key]['totalOrder']++;
            if ($order->status == 'CANCELED') {
                $data[$key]['cancelOrder']++;
                if (isset($data[$key]['cancelDetail'][$order->return_reason])) {
                    $data[$key]['cancelDetail'][$order->return_reason]++;
                } else {
                    $data[$key]['cancelDetail'][$order->return_reason] = 1;
                }
            }
            if ($order->status == 'RETURNED') {
                $data[$key]['returnOrder']++;
                if (isset($data[$key]['returnDetail'][$order->return_reason])) {
                    $data[$key]['returnDetail'][$order->return_reason]++;
                } else {
                    $data[$key]['returnDetail'][$order->return_reason] = 1;
                }
            }
            if (in_array($order->status, ['DELIVERING', 'FINISHED'])) {
                $data[$key]['successOrder']++;
            }
            if (in_array($order->status, ['PROCESSING', 'PENDING', 'ISSUED', 'READY_TO_SHIP'])) {
                $data[$key]['processingOrder']++;
            }
            if ($order->cost) {
                $data[$key]['totalCost'] += $order->cost;
                $data[$key]['totalAmount'] += $order->amount;
            }
            if ($order->fulfillment_time) {
                $data[$key]['countFulfillmentTime'] ++;
                $data[$key]['totalFulfillmentTime'] += intval($order->fulfillment_time);
            }
        }
//        $data = array_values($data);
//        foreach ($data as $key => $item) {
//            $data[$key]['costAmount'] = 0;
//            if ($item['totalAmount']) {
//                $data[$key]['costAmount'] = ceil($item['totalCost'] * 100 / $item['totalAmount']);
//            }
//            $data[$key]['averageFulfillmentTime'] = 0;
//            if ($item['countFulfillmentTime']) {
//                $data[$key]['averageFulfillmentTime'] = round($item['totalFulfillmentTime'] / $item['countFulfillmentTime']);
//            }
//            $data[$key]['averageFulfillmentTimeText'] = number_format($data[$key]['averageFulfillmentTime'] / 86400, 1) . ' ngày';
//            $data[$key]['percentIssueOrderWithPrinter'] = ceil($item['issueOrderWithPrinter'] * 100 / $item['totalOrder']);
//            $data[$key]['percentIssueOrderWithFulFill'] = ceil($item['issueOrderWithFulFill'] * 100 / $item['totalOrder']);
//        }

        return response()->json([
            'status' => 'successful',
            'data' => $data
        ]);
    }
}
