<?php

namespace Modules\Reports\Models;

use  Illuminate\Database\Eloquent\Model;
use  Modules\Pod\Models\Product;
use  Modules\Pod\Models\Design;
use  Modules\Pod\Models\User;

class DesignJob extends Model
{
    protected $connection= 'market_central';

    protected $table = 'design_job';

    protected $fillable = [
        'order_item_id', 
        'status', 
        'designer_id', 
        'order_id', 
        's_order', 
        'product_id', 
        'note', 
        'rate', 
        'meta_data', 
        'creator_id',
        'kpi_point',
        'local_code',
        'is_custom_design'
    ];

    public function product() {
        return $this->belongsTo(Product::class);
    }

    public function designer() {
        return $this->belongsTo(User::class, 'designer_id');
    }
    
    public function creator() {
        return $this->belongsTo(User::class, 'creator_id');
    }
}
