<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 9/15/21
 * Time: 9:26 AM
 */

namespace Modules\Reports\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Order extends Model
{
    protected $table = "order";
    protected $fillable = [
        'code',
        'customer_id',
        'status',
        'discount',
        'shipping_fee',
        'amount',
        'delivery_address',
        'commune_id',
        'district_id',
        'province_id',
        'country_id',
        'delivery_location_id',
        'delivery_district_id',
        'delivery_note',
        'note',
        'warehouse_id',
        'shipper_id',
        'shipping_code',
        'prepaid_amount',
        'promotion_code',
        'payment_type',
        'payment_status',
        'zip_code',
        'type',
        'search',
        'product_quantity',
        'shipping_type',
        'verifier_id',
        'state_name',
        'city_name',
        'transaction_id',
        'return_fee',
        'return_reason',
        'payment_account',
        'resource_id',
        'cost',
        'shipping_cost',
        'tax_cost',
        'other_fee',
        'is_multiple_packages'
    ];

    public function verifierStaff() {
        return $this->hasOne(User::class, "id", "verifier_id")->select(['id', 'name', 'email']);
    }

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class, 'order_id', 'id');
    }

    public function orderStatusDurations()
    {
        return $this->hasMany(OrderStatusDuration::class, 'order_id', 'id');
    }
}
