<?php

namespace Modules\Reports\Models;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $table = 'order_item';

    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id');
    }

    public function categoryRelation()
    {
        return $this->hasOneThrough(
            Category::class,
            Product::class,
            'id', // Foreign key on the products table...
            'id', // Foreign key on the categories table...
            'product_id', // Local key on the order_items table...
            'id' // Local key on the product_n_category table...
        );
    }

    public function category($categoryId = null)
    {
        $relation = $this->categoryRelation();

        if (!is_null($categoryId)) {
            $relation->where('categories.id', $categoryId);
        }

        return $relation;
    }
}