<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 9/15/21
 * Time: 9:26 AM
 */

namespace Modules\Reports\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class OrderWithFulfillment extends Order
{
    protected $appends = [
        'fulfillmentTime'
    ];

    public function getFulfillmentTimeAttribute()
    {
        $log = Log::select(['id', 'target_id', 'created_at'])
            ->where("target_type", "ORDER")
            ->where("data", "like", '%"status":"ISSUED"%')
            ->where('target_id', '=', $this->id)
            ->orderBy('id', 'asc')
            ->first();
        $retVal = 0;
        if ($log) {
            $datetime1 = strtotime($this->created_at);//start time
            $datetime2 = strtotime($log->created_at);//end time
            $retVal = abs($datetime2 - $datetime1);
        }
        return $retVal;
    }
}
