system.controller("CreatorCategoryController", CreatorCategoryController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function CreatorCategoryController($rootScope, $scope, $http) {
    
    $scope.filters = {
        category: null,
        actor: null,
        locale: locals[0]
    };
    $scope.locals = locals;
    $scope.items = [];
    $scope.categories = [];
    $scope.actors = [];

    this.initialize = function() {
        resetFilter();
    }

    const resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.sort = null;
        $scope.filters.locale = locals[0];
        $scope.filters.category = null;
        $scope.filters.actor = null;
        initDatePicker();
        getCategories();
        getActors();
        $scope.find(true);
    }

    $scope.find = () => {
        const url = buildUrl();
        $scope.data = [];
        $http.post(url).then((res) => {
            if (res.data.status === 'successful') {
                $scope.data = res.data.result;
            } else {
                $scope.data = [];
            }
        })
    }

    const getCategories = (locale) => {
        let url = baseApiUrl;
        if (locale && locale !== 'us') {
            url = url.replace('glob.api.', locale + '.api.');
        }
        return $http.get(url + '/category?filters=type=PRODUCT&page_size=-1').then((res) => {
            if (res.data.status === 'successful') {
                $scope.$applyAsync(() => {
                    $scope.categories = res.data.result;
                })
            }
        })
    }

    const getActors = (locale) => {
        let url = baseApiUrl;
        if (locale && locale !== 'us') {
            url = url.replace('glob.api.', locale + '.api.');
        }
        return $http.get(url + '/users?filters=role=STAFF&page_size=-1').then((res) => {
            if (res.data.status === 'successful') {
                $scope.$applyAsync(() => {
                    $scope.actors = res.data.result;
                })
            }
        })
    }

    $scope.changeActor = (actor) => {
        $scope.$applyAsync(() => {
            $scope.filters.actor = actor;
        })
    }
    $scope.changeCategory = (category) => {
        $scope.$applyAsync(() => {
            $scope.filters.cateogry = category;
        })
    }

    $scope.changeLocale = () => {
        const locale = $scope.filters.locale.code;
        $scope.data = [];
        $scope.filters.category = null;
        $scope.filters.actor = null;
        getCategories(locale).then(() => {
            return getActors(locale);
        }).then(() => {
            $scope.find();
        });
    }

    const buildUrl = () => {
        let url = '/report/creator/find/category?';
        if ($scope.filters.date_from) {
            url += 'dateFrom=' + formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        }
        if ($scope.filters.date_to) {
            url += '&dateTo=' + formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        }
        if ($scope.filters.category) {
            url += '&category_id=' + $scope.filters.category.id;
        }
        if ($scope.filters.actor) {
            url += '&actor_id=' + $scope.filters.actor.id;
        }
        if ($scope.filters.locale) {
            url += '&locale=' + $scope.filters.locale.code;
        }
        return url;

    }
    

    initDatePicker = function() {
        $scope.filters.date_from = getDayOfPreviousMonth();
        $scope.filters.date_to = new Date();
    }

    function getDayOfPreviousMonth()
    {
        var now = new Date();
        var retVal = now;
        if (now.getMonth() == 0) {
             retVal = new Date(now.getFullYear() - 1, 11, now.getDate());
        } else {
            retVal = new Date(now.getFullYear(), now.getMonth() - 1, now.getDate());
        }
        return retVal;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.reset = function() {
        resetFilter();
    }


    $scope.dateShow = function(date) {
        return formatDate(date, 'dd/mm/yyyy') 
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }
    $scope.changeFilter = function() {
        if ($scope.filters.classify == 'source'){
            $scope.filters.source = null;
        }
    }
    this.initialize();
}
