system.controller("CreatorRevenueController", CreatorRevenueController);
// system.config(function ($mdDateLocaleProvider) {
//     $mdDateLocaleProvider.formatDate = function (date) {
//         return moment(date).format('DD/MM/YYYY');
//     };
// });

function CreatorRevenueController($scope, $http, $rootScope, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {};
    $scope.items = [];
    $scope.users = contentUsers ? contentUsers: {};
    $scope.locates = locates;
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;
    $scope.types =
        {
            'new_product': "Sản phẩm mới",
            'old_product': "Sản phẩm cũ",
        };

    this.initialize = function() {
        resetFilter();
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.sort = null;
        $scope.filters.locate = 'us';
        $scope.filters.email = null;
        $scope.filters.type = 'create';
        $scope.filters.type_product = 'new_product';
        initDatePicker();
    }


    initDatePicker = function() {
        $scope.filters.date_from = getDayOfPreviousMonth();
        $scope.filters.date_to = new Date().
        toLocaleString('en-us', {year: 'numeric', month: '2-digit', day: '2-digit'}).
        replace(/(\d+)\/(\d+)\/(\d+)/, '$2/$1/$3');
    }

    function getDayOfPreviousMonth()
    {
        var now = new Date();
        var retVal = now;
        if (now.getMonth() == 0) {
            retVal = new Date(now.getFullYear() - 1, 11, now.getDate() - 7).
            toLocaleString('en-us', {year: 'numeric', month: '2-digit', day: '2-digit'}).
            replace(/(\d+)\/(\d+)\/(\d+)/, '$2/$1/$3');;
        } else {
            retVal = new Date(now.getFullYear(), now.getMonth(), now.getDate() - 7).
            toLocaleString('en-us', {year: 'numeric', month: '2-digit', day: '2-digit'}).
            replace(/(\d+)\/(\d+)\/(\d+)/, '$2/$1/$3');
        }
        return retVal;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.reset = function() {
        resetFilter();
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.find = function (isChangePageData, sort = null) {
        if (isChangePageData) {
            $scope.filters.page_id = 0;
        }
        if (sort != null) {
            $scope.filters.sort = sort;
        }
        $scope.items = [];
        var filter = buildFilter();
        $scope.isShowHideLoading(true);
        $scope.ajaxFindRequest = $http.post("/report/creator/find/revenue", filter).then(function (response) {
            $scope.ajaxFindRequest = null;
            if (response.data.status === "successful") {
                $scope.items = response.data.result;
                $scope.pagesCount = response.data.pagesCount;
                $scope.isShowHideLoading(false);
            }
        });
    }

    function buildFilter() {
        var retVal = {
            email: $scope.filters.email,
            locate: $scope.filters.locate,
            type: $scope.filters.type,
            type_product: $scope.filters.type_product,
            token: 'megaads@123',
        };
        if (typeof $scope.filters.sort != 'undefined' && $scope.filters.sort != null) {
            retVal.sort = $scope.filters.sort;
        }

        retVal.dateFrom = $scope.vietnameseTimeToSQLTime($scope.filters.date_from) +
        " 00:00:00";
        retVal.dateTo = $scope.vietnameseTimeToSQLTime($scope.filters.date_to) +
        " 23:59:59";
        if ($scope.filters.date_old_product_from) {
            retVal.date_old_product_from = $scope.vietnameseTimeToSQLTime($scope.filters.date_old_product_from) +
        " 00:00:00";
        }
        if ($scope.filters.date_old_product_to) {
            retVal.date_old_product_to = $scope.vietnameseTimeToSQLTime($scope.filters.date_old_product_to) +
        " 23:59:59";
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    $scope.dateShow = function(date) {
        return formatDate(date, 'dd/mm/yyyy')
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    const getActors = (locale) => {
        let url = baseApiUrl;
        if (locale && locale !== 'us') {
            url = url.replace('glob.api.', locale + '.api.');
        }
        return $http.get(url + '/users?filters=role=STAFF&page_size=-1').then((res) => {
            if (res.data.status === 'successful') {
                $scope.$applyAsync(() => {
                    $scope.actors = res.data.result;
                })
            }
        })
    }

    this.initialize();
}
