system.controller("DesignerController", DesignerController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function DesignerController($rootScope, $scope, $http) {
    
    $scope.designers = designers;
    $scope.locates = locates;
    $scope.reportDesigners = [];
    $scope.filter = {};

    this.initialize = function() {
        resetFilter();
    }

    $scope.find = () => {
        const filter = buildFilter();
        $http.post("report/designer/find", filter).then((res) => {
            if (res.data.status === "successful") {
                $scope.reportDesigners = res.data.result;
            }
        });
    }

    resetFilter = function () {
        $scope.filter.page_id = 0;
        $scope.filter.sort = null;
        $scope.filter.locate = null;
        $scope.filter.user = null;
        initDatePicker();
        $scope.find();
    };

    initDatePicker = function () {
        $scope.filter.date_from = getMonday(new Date());;
        $scope.filter.date_to = new Date();
    };

    formatDate = function (date, formatString) {
        if (typeof date == "string") {
            var dateStr = date.replace(
                /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/,
                "$2/$1/$3"
            );
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? "pm" : "am";
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? "0" + minutes : minutes;
        var strTime = hours + ":" + minutes + " " + ampm;
        if (formatString == "dd/mm/yyyy") {
            return (
                date.getDate() +
                "/" +
                (date.getMonth() + 1) +
                "/" +
                date.getFullYear()
            );
        }
        return (
            date.getMonth() +
            1 +
            "/" +
            date.getDate() +
            "/" +
            date.getFullYear() +
            "  " +
            strTime
        );
    };

    function buildFilter() {
        var retVal = {
            email: $scope.filter.user
                ? $scope.filter.user.email
                : '',
            locate: $scope.filter.locate,
        };
        if (
            typeof $scope.filter.sort != "undefined" &&
            $scope.filter.sort != null
        ) {
            retVal.sort = $scope.filter.sort;
        }

        retVal.date_from = formatDate($scope.filter.date_from, "dd/mm/yyyy");
        retVal.date_to = formatDate($scope.filter.date_to, "dd/mm/yyyy");
        retVal.page_id = $scope.filter.page_id;
        return retVal;
    }

    function getMonday(d) {
        d = new Date(d);
        var day = d.getDay(),
            diff = d.getDate() - day + (day == 0 ? -6 : 1); // adjust when day is sunday
        return new Date(d.setDate(diff));
    }

    $scope.reset = function () {
        resetFilter();
    };

    this.initialize();
}
