system.controller("HelpCentralController", HelpCentralController);
system.directive('spWorkflowChart', function () {
    return {
        restrict: 'E',
        template: '<div></div>',
        scope: {
            categories: '=',
            assigned: '=',
            done: '=',
            notresolved: '=',
            inprocess: '=',
            auto: '=',
            order: '='
        },
        link: function (scope, element) {
            var process = function () {
                Highcharts.chart(element[0], {
                    chart: {
                        type: 'column',
                        width: 1100
                    },
                    title: {
                        text: 'Tiến độ hoàn thành công việc đến thời điểm hiện tại'
                    },
                    subtitle: {
                        text: 'Source: printerval.com'
                    },
                    xAxis: {
                        categories: scope.categories,
                        accessibility: {
                            description: 'Ngày trong năm'
                        }
                    },
                    yAxis: [{
                        title: {
                            text: 'Đơn hàng | Ticket'
                        },
                        labels: {
                            format: '{value}'
                        }
                    }],
                    tooltip: {
                        shared: true, // Hiển thị tooltip cho tất cả các loại dữ liệu khi hover
                        headerFormat: '<b>{point.key}</b><br/>', // Hiển thị tiêu đề
                        pointFormat: '<span>{series.name}</span>: <b>{point.y}</b><br/>'
                    },
                    plotOptions: {
                        line: { 
                            dataLabels: {
                                enabled: true
                            },
                            enableMouseTracking: true, // Bật theo dõi chuột
                            marker: {
                                enabled: false, // Tắt marker mặc định
                                states: {
                                    hover: {
                                        enabled: true // Bật marker khi hover
                                    }
                                }
                            }
                        },
                        column: { 
                            dataLabels: {
                                enabled: true
                            },
                            enableMouseTracking: true // Bật theo dõi chuột để tooltip hoạt động cho column
                        }
                    },
                    series: [
                        {
                            name: 'Đơn hàng',
                            type: 'column',
                            color: '#7cb5ec', // Màu xanh dương cho cột
                            data: scope.order
                        }
                        ,{
                        name: 'Ticket',
                        type: 'column',
                        color: '#90ed7d', // Màu xanh dương cho cột
                        data: scope.assigned
                    },
                     {
                        name: 'Gửi tự động',
                        type: 'spline',
                        color: '#D433FF', // Màu hồng nổi bật
                        lineWidth: 3, // Tăng độ dày của đường
                        data: scope.auto
                    }
                    , {
                        name: 'Đang xử lý',
                        type: 'spline',
                        color: '#3357FF', // Màu hồng nổi bật
                        lineWidth: 3, // Tăng độ dày của đường
                        data: scope.inprocess
                    }
                    , {
                        name: 'Hoàn thành',
                        type: 'spline',
                        color: '#ff5733', // Màu cam rực rỡ cho đường spline
                        lineWidth: 3, // Tăng độ dày của đường
                        data: scope.done
                    }, {
                        name: 'Tồn chưa xử lý',
                        type: 'spline',
                        color: '#33ff57', // Màu xanh lá cây tươi sáng
                        lineWidth: 3, // Tăng độ dày của đường
                        data: scope.notresolved
                    }],                   
                });
            };
            process();
            scope.$watch("categories", function () {
                process();
            });
        }
    };
});

system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function HelpCentralController($rootScope, $scope, $http) {
    
    $scope.filters = {};
    $scope.items = [];
    $scope.users = users;
    $scope.types = {
        'order': 'Order',
        'change_order': 'Change order',
        'cancel_order': 'Cancel order',
        'tracking_code': 'Tracking code',
        'complaint': 'Complaint',
        'claim_paypal': 'Claim paypal',
        'unhappy_customer': 'Unhappy customer',
        'violates_trademark': 'Violates trademark',
        'violates_community': 'Violates community',
        'unsuitable_for_kids': 'Unsuitable for kids',
        'report_other': 'Report other',
        'issue_report': 'Issue report',
        'bulk_order': 'Bulk order',
        'seller_production': 'Seller production',
        'seller_information': 'Seller information'
    };
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;

    $scope.dataWorkflowChart = {
        categories: [],
        done: [],
        inprogress: [],
        not_resolved: [],
        assigned: [],
        auto: []
    };
    $scope.itemsChart = [];

    $scope.totalData = {
        assigned: 0,
        done: 0,
        order: 0,
        auto: 0,
    };
    this.initialize = function() {
        resetFilter();
    }

    function initFlowChart() {
        var filter = buildFilter();
        $http.post("report/help-central/build-chart", filter).then(function (response) {
            var categories = [];
            var assigned = [];
            var notResolved = [];
            var done = [];
            var inprocess = [];
            var auto = [];
            var order = [];
            if (response.data.status == 'successful') {
                $scope.itemsChart = response.data.result;
                response.data.result.forEach(function (item) {
                    categories.push(item.date);
                    assigned.push(parseInt(item.number_assigned));
                    notResolved.push(parseInt(item.number_not_solved));
                    done.push(parseInt(item.number_closed));
                    var inproc = parseInt(item.number_inprocess);
                    if (inproc > 0) {
                        inprocess.push(inproc);
                    } else {
                        inprocess.push(0);
                    }
                    auto.push(parseInt(item.number_auto));
                    order.push(parseInt(item.number_order));
                });
            }
            $scope.dataWorkflowChart.categories = categories;
            $scope.dataWorkflowChart.done = done;
            $scope.dataWorkflowChart.notresolved = notResolved;
            $scope.dataWorkflowChart.assigned = assigned;
            $scope.dataWorkflowChart.inprocess = inprocess;
            $scope.dataWorkflowChart.auto = auto;
            $scope.dataWorkflowChart.order = order;
        });
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.sort = null;
        $scope.filters.user_id = null;
        $scope.filters.type = null;
        initDatePicker();
        $scope.find();
    }
    

    initDatePicker = function() {
        $scope.filters.date_from = getPreviousMonday();
        $scope.filters.date_to = new Date();
    }
    function getPreviousMonday()
    {
        var date = new Date();
        var day = date.getDay();
        var prevMonday = new Date();
        if (day == 0) {
            prevMonday.setDate(date.getDate() - 6);
        } else {
            prevMonday.setDate(date.getDate() - (day - 1));
        }
        prevMonday.setDate(date.getDate() - 30);
        return prevMonday;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.reset = function() {
        resetFilter();
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.find = function (isChangePageData, sort = null) {
        initFlowChart();
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            if (sort != null) {
                $scope.filters.sort = sort;
            }
            var filter = buildFilter();
            $scope.isShowHideLoading(true);
            $scope.ajaxFindRequest = $http.post("report/help-central/find", filter).then(function (response) {
                $scope.ajaxFindRequest = null;
                if (response.data.status === "successful") {
                    $scope.items  = [];
                    response.data.result.forEach(function (item) {
                        item.number_assigned = parseInt(item.number_assigned);
                        item.number_closed = parseInt(item.number_closed);
                        item.number_confirm_closed = parseInt(item.number_confirm_closed);
                        item.number_message = parseInt(item.number_message);
                        var inprocess = parseInt(item.number_inprocess);
                        if (inprocess > 0) {
                            item.number_inprocess = inprocess;
                        } else {
                            item.number_inprocess = 0;
                        }
                        item.number_not_solved = parseInt(item.number_not_solved);
                        item.number_solved = parseInt(item.number_solved);
                        $scope.items.push(item);
                    });
                    $scope.isShowHideLoading(false);
                    $scope.pagesCount = response.data.pagesCount;
                }
            });
            
        }
    }

    function buildFilter() {
        var retVal = {
            user_id: $scope.filters.user_id,
            type: $scope.filters.type
        };
        
        if (typeof $scope.filters.sort != 'undefined' && $scope.filters.sort != null) {
            retVal.sort = $scope.filters.sort;
        }
       
        retVal.dateFrom = formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    $scope.showFixed = function(numb) {
        if (!isNaN(numb)) {
            return numb.toFixed(1);
        } else {
            return '';
        }
        
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    $scope.sumaryData = () => {
        $scope.totalData = {
            assigned: 0,
            done: 0,
            order: 0,
            auto: 0,
        };
        for (let index = 0; index < $scope.itemsChart.length; index++) {
            const element = $scope.itemsChart[index];
            $scope.totalData.assigned += parseFloat(element.number_assigned);
            $scope.totalData.done += parseFloat(element.number_closed);
            $scope.totalData.order += parseFloat(element.number_order);
            $scope.totalData.auto += parseFloat(element.number_auto)
        }
        $("#modal-summary").modal("toggle")
    }

    this.initialize();
}
