system.controller("PredictProductController", PredictProductController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function PredictProductController($rootScope, $scope, $http) {
    
    $scope.items = [];
    $scope.filter = {
        estimate_result: 1,
    };
    $scope.estimateStatuses = [
        {code: 0, name: 'Không có sale'},
        {code: 1, name: 'Có sale'},
    ];

    $scope.reports = {};

    this.initialize = function() {
        resetFilter();
        $scope.getReportData();
    }

    $scope.getReportData = function () {
        $http.get("report/predict/get-predict-report", {}).then((res) => {
            if (res.data.status === "successful") {
                console.log(res.data);
                
                $scope.reports = res.data.result;
            }
        });
    }

    $scope.find = (clearPageId = false) => {
        if (clearPageId) {
            $scope.filter.page_id = 0;
        }
        const filter = buildFilter();
        $http.post("report/predict/get-sale-data", filter).then((res) => {
            if (res.data.status === "successful") {
                $scope.items = res.data.items;
                $scope.pagesCount = res.data.meta.total_page;
                $scope.page_id = res.data.meta.page_id;

            }
        });
    }

    resetFilter = function () {
        $scope.filter.page_id = 0;

        initDatePicker();
        $scope.find();
    };

    initDatePicker = function () {
        const today = new Date();
        const yesterday = new Date(today);
        yesterday.setDate(today.getDate() - 1);
        $scope.filter.date_from = yesterday;
        $scope.filter.date_to = today;
    };

    formatDate = function (date, formatString) {
        if (typeof date == "string") {
            var dateStr = date.replace(
                /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/,
                "$2/$1/$3"
            );
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? "pm" : "am";
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? "0" + minutes : minutes;
        var strTime = hours + ":" + minutes + " " + ampm;
        if (formatString == "yyyy-mm-dd") {
            return (
            date.getFullYear() +
            "-" +
            (date.getMonth() + 1).toString().padStart(2, '0') +
            "-" +
            date.getDate().toString().padStart(2, '0')
            );
        }
        if (formatString == "dd/mm/yyyy") {
            return (
                date.getDate() +
                "/" +
                (date.getMonth() + 1) +
                "/" +
                date.getFullYear()
            );
        }
        return (
            date.getMonth() +
            1 +
            "/" +
            date.getDate() +
            "/" +
            date.getFullYear() +
            "  " +
            strTime
        );
    };

    function buildFilter() {
        var retVal = {
        };
        
        if ($scope.filter.date_from) {
            retVal.date_from = formatDate($scope.filter.date_from, "yyyy-mm-dd");
        }
        if ($scope.filter.date_to) {
            retVal.date_to = formatDate($scope.filter.date_to, "yyyy-mm-dd");
        }
        retVal.estimate_result = $scope.filter.estimate_result
        retVal.page_id = $scope.filter.page_id;
        retVal.product_id = $scope.filter.product_id;
        return retVal;
    }

    function getMonday(d) {
        d = new Date(d);
        var day = d.getDay(),
            diff = d.getDate() - day + (day == 0 ? -6 : 1); // adjust when day is sunday
        return new Date(d.setDate(diff));
    }

    $scope.reset = function () {
        resetFilter();
    };

    this.initialize();
}
