system.controller("ProductSourceController", ProductSourceController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ProductSourceController($rootScope, $scope, $http) {
    
    $scope.filters = {};
    $scope.items = [];
    $scope.locates = locates;
    $scope.sources = sources;
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;

    this.initialize = function() {
        resetFilter();
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.sort = null;
        $scope.filters.locate = 'us';
        $scope.filters.source = null;
        $scope.filters.classify = 'source';
        getSources().then(() => {
            initDatePicker();
            $scope.find(true);
        })
    }
    

    initDatePicker = function() {
        $scope.filters.date_from = getDayOfPreviousMonth();
        $scope.filters.date_to = new Date();
    }

    const getSources = () => {
        const locale = $scope.filters.locate;
        let apiUrl = baseApiUrl;
        if (locale !== "us" && baseApiUrl.includes("glob.api.")) {
            apiUrl = baseApiUrl.replace("glob.api.", locale + ".api.");
        } else {
            apiUrl = baseApiUrl.replace("central.api.", locale + ".api.");
        }
        return $http.get(apiUrl + '/source?page_size=-1').then((res) => {
            if (res.data.status = 'successful') {
                $scope.sources = {};
                res.data.result.forEach((source) => {
                    $scope.sources[source.id] = source.name;
                });
            }
        })

    }

    function getDayOfPreviousMonth()
    {
        var now = new Date();
        var retVal = now;
        if (now.getMonth() == 0) {
             retVal = new Date(now.getFullYear() - 1, 11, now.getDate());
        } else {
            retVal = new Date(now.getFullYear(), now.getMonth() - 1, now.getDate());
        }
        return retVal;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.reset = function() {
        resetFilter();
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.search = () => {
        getSources().then(() => {
            $scope.find(true);
        })
    }

    $scope.find = function (isChangePageData, sort = null) {
        $scope.items = [];
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            if (sort != null) {
                $scope.filters.sort = sort;
            }
            var filter = buildFilter();
            $scope.isShowHideLoading(true);
            $scope.ajaxFindRequest = $http.post("report/product/find/source", filter).then(function (response) {
                $scope.ajaxFindRequest = null;
                if (response.data.status === "successful") {
                    $scope.items = response.data.result;
                    $scope.pagesCount = response.data.pagesCount;
                    $scope.isShowHideLoading(false);
                }
            });
            
        }
    }

    function buildFilter() {
        var retVal = {
            source_id: $scope.filters.source,
            locale: $scope.filters.locate,
            group_by: 'source_id',
        };
        if (typeof $scope.filters.sort != 'undefined' && $scope.filters.sort != null) {
            retVal.sort = $scope.filters.sort;
        }
       
        retVal.dateFrom = formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    $scope.dateShow = function(date) {
        return formatDate(date, 'dd/mm/yyyy') 
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }
    $scope.changeFilter = function() {
        $scope.find(true);
    }
    this.initialize();
}
