system.controller("ReportDesignController", ReportDesignController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ReportDesignController($scope, $rootScope, $http, $timeout) {

    $scope.items = [];
    $scope.filters = {

    };
    $scope.appUrl = app_url;
    $scope.loadChartDesignJob = false;
    $scope.loadChartConversionRate = false;
    $scope.loadChartPerformanceAds = false;
    Highcharts.setOptions({
        lang: {
            thousandsSep: ""
        }
    });


    this.initialize = function() {
        initDatePicker();
        $scope.find();
    }

    $scope.find = (clearPageId = false) => {
        $scope.displayDesignJob();
        $scope.displayConversionRate();
        $scope.displayAdvertisingPerformance();
    }

    $scope.displayDesignJob = function () {
        $scope.loadChartDesignJob = true;
        let locale = localeCode;
        let url = $scope.appUrl + '/report/performance/design/count-design?locale=' + locale + '&start=' + $scope.filters.date_from + '&end=' + $scope.filters.date_to;
        $http.get(url).then((res) => {
           if (res.data.status == 'successful') {
               $scope.loadChartDesignJob = false;
               let reDesign = res.data.reDesign;
               let needDesign = res.data.needDesign;
               let hasDesign = res.data.hasDesign;
               let total = reDesign + needDesign + hasDesign;
               if (total > 0) {
                   let percentNeedDesign = parseFloat(((needDesign / total) * 100).toFixed(2));
                   let percentReDesign = parseFloat(((reDesign / total) * 100).toFixed(2));
                   let percentHasDesign = parseFloat((100 - percentNeedDesign - percentReDesign).toFixed(2));
                   let dataChart = [
                       {
                           name: 'Cần re design',
                           y: percentReDesign,
                           number: reDesign
                       },
                       {
                           name: 'Chưa có design',
                           y: percentNeedDesign,
                           number: needDesign
                       },
                       {
                           name: 'Có sẵn design',
                           y: percentHasDesign,
                           number: hasDesign
                       }
                   ];
                   Highcharts.chart('design-jobs', {
                       chart: {
                           type: 'pie'
                       },
                       title: {
                           text: '1. Tỷ lệ design jobs',
                           align: 'left',
                           style: {
                               fontSize: 20
                           }
                       },
                       tooltip: {
                           valueSuffix: '%',
                           useHTML: true,
                           formatter: function() {
                               return '<div style="text-align: center;">' +
                                   '<span style="font-size: 1em;"><strong>Số design</strong>: ' + this.point.number + '</span>' +
                                   '</div>';
                           },
                           style: {
                               fontSize: '15px'
                           }
                       },
                       plotOptions: {
                           series: {
                               allowPointSelect: true,
                               cursor: 'pointer',
                               dataLabels: [{
                                   enabled: true,
                                   distance: 20,
                                   style: {
                                       fontSize: '16px',
                                       color: '#000',
                                       textOutline: 'none'
                                   }
                               }, {
                                   enabled: true,
                                   distance: -40,
                                   format: '{point.percentage:.1f}%',
                                   style: {
                                       fontSize: '1.8em',
                                       textOutline: 'none',
                                       opacity: 0.7
                                   },
                                   filter: {
                                       operator: '>',
                                       property: 'percentage',
                                       value: 10
                                   }
                               }]
                           }
                       },
                       series: [
                           {
                               name: 'Percentage',
                               colorByPoint: true,
                               data: dataChart
                           }
                       ]
                   });
               }
           }
        });

    }

    $scope.displayConversionRate = function () {
        $scope.loadChartConversionRate = true;
        let locale = localeCode;
        let urlConversionRate = $scope.appUrl + '/report/performance/design/conversion-rate?locale=' + locale + '&start=' + $scope.filters.date_from + '&end=' + $scope.filters.date_to;
        $http.get(urlConversionRate).then((res) => {
            if (res.data.status === 'successful') {
                $scope.loadChartConversionRate = false;
                let availableDesignRes = res.data.result.availableDesign;
                let needDesignRes = res.data.result.needDesign;
                let availableDesign = [];
                let needDesign = [];
                Object.keys(availableDesignRes).forEach(key => {
                    let availableDesignObj = {
                        orders: availableDesignRes[key].number_order,
                        clicks: availableDesignRes[key].number_click,
                        date: key,
                    }
                    let rateConversion = availableDesignObj.clicks == 0 ? 0 : parseFloat(((availableDesignObj.orders / availableDesignObj.clicks) * 100).toFixed(2));
                    availableDesignObj.y = rateConversion;
                    availableDesign.push(availableDesignObj);
                });
                Object.keys(needDesignRes).forEach(key => {
                    let needDesignObj = {
                        orders: needDesignRes[key].number_order,
                        clicks: needDesignRes[key].number_click,
                        date: key,
                    }
                    let rateConversion = needDesignObj.clicks == 0 ? 0 : parseFloat(((needDesignObj.orders / needDesignObj.clicks) * 100).toFixed(2));
                    needDesignObj.y = rateConversion;
                    needDesign.push(needDesignObj);
                });
                let inputs = {
                    id: 'conversion-rate',
                    title: '2. Tỷ lệ chuyển đổi',
                    header: 'Tỷ lệ chuyển đổi',
                    seriesDataLineFirst: availableDesign,
                    seriesNameLineFirst: 'Có sẵn design',
                    seriesDataLineSecond: needDesign,
                    seriesNameLineSecond: 'Cần có design'
                }
                buildDataHighChart(inputs);
            }
        })
    }

    $scope.displayAdvertisingPerformance = function () {
        $scope.loadChartPerformanceAds = true;
        let locale = localeCode;
        let url = $scope.appUrl + '/report/performance/design/ads?locale=' + locale + '&start=' + $scope.filters.date_from + '&end=' + $scope.filters.date_to;
        $http.get(url).then((res) => {
           if (res.data.status == 'successful') {
               $scope.loadChartPerformanceAds = false;
               let productAvailableDesign = [];
               let sellerDesign = [];
               let responseHasDesign = res.data.result.has_design;
               Object.keys(responseHasDesign).forEach(item => {
                   productAvailableDesign.push(
                       {
                           y: parseInt(responseHasDesign[item].clicks),
                           date: reformatDate(item),
                           clicks: parseInt(responseHasDesign[item].clicks),
                       }
                   );
               });
               let responseSeller = res.data.result.seller;
               Object.keys(responseSeller).forEach(item => {
                   sellerDesign.push(
                       {
                           y: parseInt(responseSeller[item].clicks),
                           date: reformatDate(item),
                           clicks: parseInt(responseSeller[item].clicks)
                       }
                   );
               });
               let inputs = {
                   id: 'advertising-performance',
                   title: '3. Hiệu suất quảng cáo',
                   header: 'Hiệu suất quảng cáo',
                   seriesDataLineFirst: productAvailableDesign,
                   seriesNameLineFirst: 'Sản phẩm có sẵn design',
                   seriesDataLineSecond: sellerDesign,
                   seriesNameLineSecond: 'Sản phẩm của seller'
               }
               buildDataHighChart(inputs, true);
           }
        });
    }

    function initDatePicker() {
        let today = new Date();
        today.setDate(today.getDate() - 7);
        let dateFrom = today;
        let dateTo = new Date();
        $scope.filters.date_from = formatDate(dateFrom);
        $scope.filters.date_to = formatDate(dateTo);
    }

    $scope.reset = function () {
        initDatePicker();
        $scope.find();
    }

    function getDayOfPreviousMonth()
    {
        let now = new Date();
        let retVal = now;
        if (now.getMonth() == 0) {
            retVal = new Date(now.getFullYear() - 1, 11, now.getDate());
        } else {
            retVal = new Date(now.getFullYear(), now.getMonth() - 1, now.getDate());
        }
        return retVal;
    }

    function formatDate(date) {
        const day = String(date.getDate()).padStart(2, '0');
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const year = date.getFullYear();

        return `${day}/${month}/${year}`;
    }

    function buildDataHighChart(inputs, isAds = false) {
        let id = inputs.id;
        let title = inputs.title;
        let header = inputs.header;
        let position = inputs.position ?? 'left';
        let dataLineFirst = inputs.seriesDataLineFirst;
        let nameLineFirst = inputs.seriesNameLineFirst;
        let dataLineSecond = inputs.seriesDataLineSecond;
        let nameLineSecond = inputs.seriesNameLineSecond;
        let labelYAxis = [];
        dataLineFirst.forEach((item, index) => {
            labelYAxis.push(item.date);
        });
        Highcharts.chart(id, {
            title: {
                text: title,
                align: position,
                style: {
                    fontSize: '20px'
                }
            },

            xAxis: {
                labels: {
                    style: {
                        fontSize: '12px'
                    },
                    formatter: function() {
                        return labelYAxis[this.value];
                    }
                }
            },

            yAxis: {
                title: {
                    text: header
                }
            },

            tooltip: {
                useHTML: true,
                formatter: function() {
                    let result = '<div style="text-align: left;">' +
                        '<span style="font-size: 1em;font-style: italic"><strong>' + this.point.series.name + '</strong></span><br>';
                    if (!isAds) {
                        result += '<span style="font-size: 1em;"><strong>Số order</strong>: ' + this.point.orders + '</span><br>';
                    }
                    result += '<span style="font-size: 1em;"><strong>Số clicks</strong>: ' + this.point.clicks + '</span><br>';
                    if (!isAds) {
                        result += '<span style="font-size: 1em;"><strong>Tỷ lệ</strong>: ' + this.point.y + '%</span><br>';
                    }
                    result += '<span style="font-size: 1em;"><strong>Ngày</strong>: ' + this.point.date + '</span>' +
                        '</div>';

                    return result;
                },
                style: {
                    fontSize: '15px'
                }
            },

            legend: {
                layout: 'vertical',
                align: 'right',
                verticalAlign: 'middle',
                itemStyle: {
                    color: '#333333',
                    fontStyle: 'italic',
                    fontSize: '12px',
                    fontFamily: 'Arial, sans-serif'
                }
            },

            plotOptions: {
                line: {
                    marker: {
                        enabled: true
                    }
                }
            },

            series: [{
                name: nameLineFirst,
                data: dataLineFirst,
            }, {
                name: nameLineSecond,
                data: dataLineSecond
            }],

            responsive: {
                rules: [{
                    condition: {
                        maxWidth: 500
                    },
                    chartOptions: {
                        legend: {
                            layout: 'horizontal',
                            align: 'center',
                            verticalAlign: 'bottom'
                        }
                    }
                }]
            }
        });
    }

    function reformatDate(dateString) {
        const parts = dateString.split('-');

        return `${parts[2]}-${parts[1]}-${parts[0]}`;
    }

    this.initialize();
}
