system.controller("ReportPrintingShopController", ReportPrintingShopController);

function ReportPrintingShopController($rootScope, $scope, $http) {
    $scope.dataMedium = [];
    $scope.locates = locates;
    $scope.filters = {};
    $scope.chart = false;
    $scope.listCategory = [];
    $scope.listPrinting = [];
    $scope.dataChart = [];
    $scope.dataAverage = [];
    $scope.dataPercentInStatus = []
    $scope.percentInStatus = []
    $scope.totalPercentInStatus = []
    $scope.dataIssue = [];
    $scope.allDataIssue = [];
    $scope.totalPercentIssue = [];

    $scope.tab = 'tab1';

    $scope.filters = {
        date_from: getPreviousMonday(),
        date_to: new Date(),
        category_id: '',
        printing_code: ''
    };
    $scope.filtersTab2 = {
        date_from: getPreviousMonday(),
        date_to: new Date(),
        category_id: '',
        printing_code: ''
    };
    $scope.filtersTab3 = {
        date_from: getPreviousMonday(),
        date_to: new Date(),
        category_id: '',
        printing_code: ''
    };

    $scope.filtersDefault = {};

    $scope.isTab1 = true;
    $scope.isTab2 = false;
    $scope.isTab3 = false;

    $scope.colorLists = ['rgb(17,137,193)', 'rgb(240,119,25)', '#adc560', '#e7540c', '#9fcbe1', '#ccc', '#6aafd7', '#6078ae', '#b8501c'];

    $scope.arrayStatus = [
        'PENDING', 'READY_TO_SHIP', 'PROCESSING', 'DELIVERING', 'FINISHED'
    ]

    $scope.initialize = function () {
        resetFilter(1);
        getCategory();
        getPrinting();
    }

    formatDate = function (date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0' + minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth() + 1) + "/" + date.getFullYear();
        }
        return (date.getMonth() + 1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    initDatePicker = function (stt) {
        if (stt === 1) {
            $scope.filters.date_from = getPreviousMonday();
            $scope.filters.date_to = new Date();
        } else if (stt === 2) {
            $scope.filtersTab2.date_from = getPreviousMonday();
            $scope.filtersTab2.date_to = new Date();
        } else {
            $scope.filtersTab3.date_from = getPreviousMonday();
            $scope.filtersTab3.date_to = new Date();
        }
    }

    function getPreviousMonday() {
        var date = new Date();
        var day = date.getDay();
        var prevMonday = new Date();
        if (day == 0) {
            prevMonday.setDate(date.getDate() - 6);
        } else {
            prevMonday.setDate(date.getDate() - (day - 1));
        }

        return prevMonday;
    }

    resetFilterTab3 = function (stt) {
        initDatePicker(stt);
        $scope.filtersTab3.page_id = 0;
        $scope.filtersTab3.category = null;
        $scope.filtersTab3.printing = null;

        $scope.findTab2();
    }

    resetFilterTab2 = function (stt) {
        initDatePicker(stt);
        $scope.filtersTab2.page_id = 0;
        $scope.filtersTab2.category = null;
        $scope.filtersTab2.printing = null;

        $scope.findTab2();
    }

    resetFilter = function (stt) {
        initDatePicker(stt);
        $scope.filters.page_id = 0;
        $scope.filters.category = null;
        $scope.filters.printing = null;

        $scope.filtersDefault = angular.copy($scope.filters);

        $scope.find();
    }

    function getCategory() {
        $http.get('/report/printing-shop/get-category')
            .then((response) => {
                if (response.data.status === 'successful') {
                    $scope.listCategory = response.data.data;
                }
            }, function () {

            });
    }

    function getPrinting() {
        $http.get('/report/printing-shop/get-printing')
            .then((response) => {
                if (response.data.status === 'successful') {
                    $scope.listPrinting = response.data.data;
                }
            }, function () {

            });
    }

    $scope.changeTab = function (type) {
        if (type === 'tab1') {
            $scope.isTab1 = true;
            $scope.isTab2 = $scope.isTab3 = false
            $scope.tab = 'tab1';

            $scope.find();
        }
        if (type === 'tab2') {
            $scope.isTab2 = true;
            $scope.isTab1 = $scope.isTab3 = false;
            $scope.tab = 'tab2';

            $scope.findTab2();
        }
        if (type === 'tab3') {
            $scope.isTab3 = true;
            $scope.isTab2 = $scope.isTab1 = false;
            $scope.tab = 'tab3';

            $scope.findTab3();
        }
    }

    $scope.buildParams = function (url) {
        let retVal = {};

        retVal.dateFrom = formatDate($scope.filtersDefault.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filtersDefault.date_to, 'dd/mm/yyyy');
        retVal.page_id = $scope.filtersDefault.page_id;

        let params = '?start_date=' + retVal.dateFrom + '&end_date=' + retVal.dateTo + '&page_id=' + retVal.page_id;
        if ($scope.filtersDefault.category != null) {
            params += '&category_id=' + $scope.filtersDefault.category;
        }
        if ($scope.filtersDefault.printing) {
            params += '&printing_code=' + $scope.filtersDefault.printing;
        }

        url += params;

        return url;
    }


    $scope.buildDataChartFixed = function () {
        for (const i of $scope.dataChart) {
            if (i.total_cost == null) {
                i.total_cost = "0.00";
            }
            if (i.total_shipping_cost == null) {
                i.total_shipping_cost = "0.00";
            }
            if (i.total_tax_cost == null) {
                i.total_tax_cost = "0.00";
            }
            i.total = parseFloat(i.total_cost) + parseFloat(i.total_shipping_cost) + parseFloat(i.total_tax_cost);
            if (i.printing_code == null) {
                i.printing_code = 'unknow';
            }
        }
    }

    $scope.buildDataAverage = function () {
        for (let i of $scope.dataAverage) {
            if (i.printing_code == null) {
                i.printing_code = 'unknow';
            }

            let time_average_production = parseFloat(i.issued_time_count) <= 0 ? 0 : ((parseFloat(i.issued_time_sum) / parseFloat(i.issued_time_count)) / (3600 * 24));
            let time_average_delivering = parseFloat(i.delivering_time_count) <= 0 ? 0 : ((parseFloat(i.delivering_time_sum) / parseFloat(i.delivering_time_count)) / (3600 * 24));

            i.time_average_production = Math.round(time_average_production);
            i.time_average_delivering = Math.round(time_average_delivering);
        }
    }

    $scope.calculatePercent = function () {
        $scope.dataPercentInStatus = [];
        for (let i of $scope.percentInStatus) {
            if (i.printing_code == null) {
                i.printing_code = 'unknow';
            }
            let findPrinting = $scope.dataPercentInStatus.find((a => a.printing_code === i.printing_code));
            if (findPrinting) {
                findPrinting[i.status] = i.total_products;
                let percent = Math.round((i.total_products / $scope.totalPercentInStatus[i.status]) * 10000) / 10000;
                percent = percent * 100;
                findPrinting['percent_' + i.status] = ((Math.round(percent * 100) / 100) + '%');
            } else {
                let data = {
                    "printing_code": i.printing_code,
                }
                data[i.status] = i.total_products;
                let percent = Math.round((i.total_products / $scope.totalPercentInStatus[i.status]) * 10000) / 10000;
                percent = percent * 100;
                data['percent_' + i.status] = ((Math.round(percent * 100) / 100) + '%');

                $scope.dataPercentInStatus.push(data);
            }
        }
    }

    $scope.calculatePercentIssue = function () {
        $scope.dataIssue = [];
        for (let i of $scope.allDataIssue) {
            if (i.printing_code == null) {
                i.printing_code = 'unknow';
            }
            let find = $scope.dataIssue.find((a) => a.printing_code == i.printing_code);
            let data = {};

            if (!find) {
                data.total_order = $scope.totalPercentIssue[i.printing_code];
                data.total_feedback_issue = i.total_feedback_issue;
                data.printing_code = i.printing_code;
                data.detail = [];
            }

            if (i.feedback_issue != null) {
                let dataDetail = {
                    'name_issue': i.feedback_issue,
                    'total_feedback_issue': i.total_feedback_issue
                }
                let percent = i.total_order / $scope.totalPercentIssue[i.printing_code];
                percent = Math.round(percent * 10000) / 10000;
                percent = percent * 100;

                dataDetail['percent'] = (Math.round(percent * 100) / 100) + '%';

                if (find) {
                    find.total_feedback_issue += i.total_feedback_issue;
                    find.detail.push(dataDetail)
                } else {
                    data.detail.push(dataDetail)
                }
            }
            if (!find) {
                $scope.dataIssue.push(data);
            }
        }
        $scope.calculatePercentAllIssue();
    }

    $scope.calculatePercentAllIssue = function () {
        for (let item of $scope.dataIssue) {
            let percentAll = item.total_feedback_issue / $scope.totalPercentIssue[item.printing_code];
            percentAll = Math.round(percentAll * 10000) / 10000;
            percentAll = percentAll * 100;

            item.percent = (Math.round(percentAll * 100) / 100) + '%';
        }
    }

    $scope.getDataChart = function () {
        let url = $scope.buildParams('/report/printing-shop/find-chart')
        $http.get(url)
            .then((response) => {
                if (response.data.status === 'successful') {
                    $scope.dataChart = response.data.result.dataChart;
                    //fixed data null
                    $scope.buildDataChartFixed();
                    //create chart
                    if ($scope.dataChart.length > 0) {
                        $scope.createChart();
                    }
                }
            }, function () {
            });
    }

    $scope.getDataAverage = function () {
        let url = $scope.buildParams('/report/printing-shop/find-average')
        $http.get(url)
            .then((response) => {
                if (response.data.status === 'successful') {
                    $scope.dataAverage = response.data.result.dataAverage;
                    $scope.buildDataAverage();
                    $scope.dataAverage = $scope.sortArray(1, 'time_average_production', true)
                }
            }, function () {
            });
    }

    $scope.getDataPercentInStatus = function () {
        let url = $scope.buildParams('/report/printing-shop/find-percent-status')
        $http.get(url)
            .then((response) => {
                if (response.data.status === 'successful') {
                    $scope.percentInStatus = response.data.result.percentInStatus;
                    $scope.totalPercentInStatus = response.data.result.totalPercentInStatus;
                    //calculate % of status
                    $scope.calculatePercent();

                    $scope.dataPercentInStatus = $scope.sortArray(2, 'PENDING', true)
                }
            }, function () {
            });
    }

    $scope.getDataIssue = function () {
        let url = $scope.buildParams('/report/printing-shop/find-issue')
        $http.get(url)
            .then((response) => {
                if (response.data.status === 'successful') {
                    $scope.allDataIssue = response.data.result.dataIssue;
                    $scope.totalPercentIssue = response.data.result.totalPercentIssue;
                    //caculate % of issue
                    $scope.calculatePercentIssue();

                    $scope.dataIssue = $scope.sortArray(3, 'total_order', true)
                }
            }, function () {
            });
    }

    $scope.find = function () {
        $scope.filtersDefault = angular.copy($scope.filters);

        $scope.getDataChart();
        $scope.getDataAverage();

    }

    $scope.findTab2 = function () {
        $scope.filtersDefault = angular.copy($scope.filtersTab2);

        $scope.getDataChart();
        $scope.getDataPercentInStatus();
    }

    $scope.findTab3 = function () {
        $scope.filtersDefault = angular.copy($scope.filtersTab3);

        $scope.getDataChart();
        $scope.getDataIssue();
    }

    $scope.sortArray = function (type, key, ascending = true) {
        let arrSort = [];
        if (type === 1) {
            arrSort = $scope.dataAverage;
        } else if (type === 2) {
            arrSort = $scope.dataPercentInStatus;
        } else {
            arrSort = $scope.dataIssue;
        }
        return arrSort.sort((a, b) => {
            if ((a[key] ?? 0) < (b[key] ?? 0)) {
                return ascending ? -1 : 1;
            }
            if ((a[key] ?? 0) > (b[key] ?? 0)) {
                return ascending ? 1 : -1;
            }
            return 0;
        });
    }

    $scope.createChart = function () {
        var labels = [];
        var totals = [];
        var totalSum = 0;

        $scope.dataChart.forEach(function (item) {
            labels.push($scope.getNamePrinting(item.printing_code));
            totals.push(parseFloat(item.total));
            totalSum += item.total;
        });

        var percentages = totals.map(function (total) {
            return (total / totalSum * 100).toFixed(2);
        });

        if ($scope.chart) {
            $scope.chart.destroy();
        }

        Highcharts.chart('myHighChart-' + $scope.tab, {
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false,
                type: 'pie',
                height: 400
            },
            title: {
                text: null
            },
            tooltip: {
                pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            accessibility: {
                point: {
                    valueSuffix: '%'
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
                        format: '<b><strong>{point.name}</strong></strong></b>: {point.percentage:.1f} %',
                        style: {
                            fontSize: '12px', // Tăng cỡ chữ
                            fontWeight: '600' // In đậm chữ
                        },
                        connectorColor: 'silver'
                    },
                    showInLegend: true,
                    innerSize: 65,
                    depth: 40,
                    colors: $scope.colorLists
                }
            },
            legend: {
                itemStyle: {
                    fontSize: '12px', // Tăng cỡ chữ
                    fontWeight: '600' // In đậm chữ
                }
            },
            series: [{
                name: 'Chi phí',
                colorByPoint: true,
                dataLabels: {
                    style: {
                        fontSize: '12px', // Tăng cỡ chữ
                        fontWeight: '600' // In đậm chữ
                    }
                },
                data: labels.map((label, index) => ({
                    name: label,
                    y: totals[index],
                    percentage: parseFloat(percentages[index])
                }))
            }]
        });
    };

    $scope.showModal = function (item) {
        $scope.detailError = item.detail
        $scope.showHideModal();
    }

    $scope.showHideModal = function () {
        $('#modal-post').modal('toggle');
    }

    $scope.getNamePrinting = function (printing_code) {
        let find = $scope.listPrinting.find((i) => i.code == printing_code);

        if (!find) {
            return printing_code;
        }
        return find.name;
    }

    $scope.initialize();
}