system.controller("ResendController", ResendController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function ResendController($rootScope, $scope, $http) {
    
    $scope.filters = {};
    $scope.items = [];
    $scope.categories = [];
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;
    $scope.localization = dashboardLocalization;
    $scope.listReason = [
        {code: 'print_provider', name: 'Lỗi Nhà In'},
        {code: 'customer', name: 'Lỗi Khách Hàng'},
        {code: 'fulfill', name: 'Lỗi Fulfill'},
        {code: 'design', name: 'Lỗi Design'},
        {code: 'support', name: 'Lỗi Support'},
        {code: 'content', name: 'Lỗi Content'},
        {code: 'tool', name: 'Lỗi Tool'},
        {code: 'other', name: 'Không Lỗi'},
    ];
    $scope.listType = [
        {code: 'resend', name: 'Resend'},
        {code: 'refund', name: 'Refund'},
    ];
    this.initialize = function() {
        resetFilter();
    }

    resetFilter = function() {
        $scope.filters = {};
        
        initDatePicker();
        $scope.find();
    }
    

    initDatePicker = function() {
        var date = new Date();
        date.setDate(date.getDate() - 30);
        $scope.filters.date_from = date;
        $scope.filters.date_to = new Date();
    }

    $scope.reset = function() {
        resetFilter();
    }

    $scope.find = function () {
        $scope.items = [];
        var filter = buildFilter();
        $scope.isShowHideLoading(true);
        $http.post('/reports/resend/find', filter).then(function (response) {
            if (response.data.status == "successful" && response.data.data) {
                $scope.items = response.data.data;
            }
            $scope.isShowHideLoading(false);
        }, function (error) {
        });
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.type) {
            retVal.type = $scope.filters.type;
        }
        if ($scope.filters.reason) {
            retVal.reason = $scope.filters.reason;
        }
        if ($scope.filters.order_code) {
            retVal.order_code = $scope.filters.order_code;
        }

       
        retVal.dateFrom = formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        return retVal;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    $scope.summarizeDateTime = function (dateTime, withYear) {
        if (dateTime != null) {
            var outputFormat = "$3/$2";
            if (withYear) {
                outputFormat += "/$1";
            }
            outputFormat += " $4:$5";
            return dateTime.replace(/(\d{4})-(\d{2})-(\d{2})\s+(\d{1,2}):(\d{1,2}):.*/, outputFormat);
        }
    };

    this.initialize();
}
