system.controller("VerifierController", VerifierController);
system.config(function ($mdDateLocaleProvider) {
    $mdDateLocaleProvider.formatDate = function (date) {
        return moment(date).format('DD/MM/YYYY');
    };
});

function VerifierController($rootScope, $scope, $http) {
    
    $scope.filters = {};
    $scope.items = [];
    $scope.categories = [];
    $scope.ajaxFindRequest = null;
    $scope.isChangeData = false;
    $scope.localization = dashboardLocalization;
    this.initialize = function() {
        resetFilter();
    }

    resetFilter = function() {
        $scope.filters.page_id = 0;
        $scope.filters.keyword = '';
        $scope.filters.sort = null;
        
        initDatePicker();
        $scope.find();
    }
    

    initDatePicker = function() {
        $scope.filters.date_from = getPreviousMonday();
        $scope.filters.date_to = new Date();
    }

    function getPreviousMonday()
    {
        var date = new Date();
        var day = date.getDay();
        var prevMonday = new Date();
        if (day == 0) {
            prevMonday.setDate(date.getDate() - 6);
        } else {
            prevMonday.setDate(date.getDate() - (day - 1));
        }

        return prevMonday;
    }

    formatDate = function(date, formatString) {
        if (typeof date == 'string') {
            var dateStr = date.replace(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/, '$2/$1/$3');
            date = new Date(dateStr);
        }
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var ampm = hours >= 12 ? 'pm' : 'am';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        var strTime = hours + ':' + minutes + ' ' + ampm;
        if (formatString == 'dd/mm/yyyy') {
            return date.getDate() + "/" + (date.getMonth()+1) + "/" +  date.getFullYear();
        }
        return (date.getMonth()+1) + "/" + date.getDate() + "/" + date.getFullYear() + "  " + strTime;
    }

    $scope.reset = function() {
        resetFilter();
    }

    $scope.exportExcel = function() {
        var url = "/payment-stats/export-excel";
        var filter = buildFilter();
        var params = getParams(filter);
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        url += '&is_export=1';
        window.open(url, '_blank');
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.find = function (isChangePageData, sort = null) {
        if ($scope.ajaxFindRequest === null) {
            if (isChangePageData) {
                $scope.filters.page_id = 0;
            }
            $scope.filters.sort = null;
            var filter = buildFilter();
            // $scope.isShowHideLoading(true);

            var localizationPromise = [];
            for (var k in $scope.localization) {
                var item = $scope.localization[k];
                if (item.enable && item.locale != 'glob') {
                    localizationPromise.push(new Promise (function (resolve) {
                        var locale = item.locale;
                        $http.post('/' + item.locale + '/reports/verifier/find', filter ).then(function (response) {
                            if (response.data.status == "successful" && response.data.data) {
                                resolve({ locale: locale, data: response.data.data});
                            } else {
                                resolve({ locale: locale, data: []});
                            }
                        }, function (error) {
                            resolve({ locale: locale, data: []});
                        });
                    }));
                }
            }
            $scope.items = [];
            $scope.ajaxFindRequest = Promise.all(localizationPromise).then(function (localizationData) {
                var itemsByEmail = [];
                localizationData.forEach(function (item, index) {
                    for (var email in item.data) {
                        if (typeof itemsByEmail[email] == "undefined") {
                            itemsByEmail[email] = item.data[email];
                        } else {
                            itemsByEmail[email].cancelOrder += item.data[email].cancelOrder;
                            itemsByEmail[email].countFulfillmentTime += item.data[email].countFulfillmentTime;
                            itemsByEmail[email].processingOrder += item.data[email].processingOrder;
                            itemsByEmail[email].returnOrder += item.data[email].returnOrder;
                            itemsByEmail[email].successOrder += item.data[email].successOrder;
                            itemsByEmail[email].totalAmount += item.data[email].totalAmount;
                            itemsByEmail[email].totalCost += item.data[email].totalCost;
                            itemsByEmail[email].totalFulfillmentTime += item.data[email].totalFulfillmentTime;
                            itemsByEmail[email].totalOrder += item.data[email].totalOrder;
                            for (var i in item.data[email].returnDetail) {
                                if (typeof itemsByEmail[email].returnDetail[i] != 'undefined') {
                                    itemsByEmail[email].returnDetail[i] += item.data[email].returnDetail[i];
                                } else {
                                    itemsByEmail[email].returnDetail[i] = item.data[email].returnDetail[i];
                                }
                            }
                            for (var i in item.data[email].cancelDetail) {
                                if (typeof itemsByEmail[email].cancelDetail[i] != 'undefined') {
                                    itemsByEmail[email].cancelDetail[i] += item.data[email].cancelDetail[i];
                                } else {
                                    itemsByEmail[email].cancelDetail[i] = item.data[email].cancelDetail[i];
                                }
                            }
                        }
                    }
                })
                for (var email in itemsByEmail) {
                    var item = itemsByEmail[email];
                    item.costAmount = 0;
                    if (item.totalAmount) {
                        item.costAmount = Math.ceil(item.totalCost * 100 / item.totalAmount);
                    }
                    item.averageFulfillmentTime = 0;
                    if (item.countFulfillmentTime) {
                        item.averageFulfillmentTime = item.totalFulfillmentTime / item.countFulfillmentTime;
                    }
                    item.averageFulfillmentTimeText = (item.averageFulfillmentTime / 86400).toFixed(1) + ' ngày';
                    $scope.items.push(itemsByEmail[email]);
                }
                $scope.$apply();
                $scope.ajaxFindRequest = null;
            })
        }
    }

    $scope.sort = function (sort) {
        if (sort) {
            $scope.filters.sort = sort;
            $scope.items.sort(sortFunction);
        }
    }

    function sortFunction(a, b) {
        var arrSort = $scope.filters.sort.split('-');
        var key = arrSort[0];
        var compare = arrSort[1];
        if (a[key] === b[key]) {
            return 0;
        }
        else {
            if (compare == 'asc') {
                return (a[key] < b[key]) ? -1 : 1;
            } else {
                return (a[key] < b[key]) ? 1 : -1;
            }
        }
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword != '') {
            retVal.keyword = $scope.filters.keyword;
        }
        // if (typeof $scope.filters.sort != 'undefined' && $scope.filters.sort != null) {
        //     retVal.sort = $scope.filters.sort;
        // }
       
        retVal.dateFrom = formatDate($scope.filters.date_from, 'dd/mm/yyyy');
        retVal.dateTo = formatDate($scope.filters.date_to, 'dd/mm/yyyy');
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    $scope.isShowHideLoading = function(val) {
        $scope.isShowLoading = val;
    }

    $scope.getReturnDetail = function (item) {
        let retVal = [];
        var arr = [];
        if (item.returnDetail) {
            for (var reason in item.returnDetail) {
                arr.push({count: item.returnDetail[reason], text: (reason ? reason : 'UNKNOWN') + ': <b>' + item.returnDetail[reason] + '</b>'})
            }
            arr.sort(sortCountFunction);
            for (var i in arr) {
                retVal.push(arr[i].text);
            }
        }
        return retVal.join('<br>');
    }
    $scope.getCancelDetail = function (item) {
        let retVal = [];
        var arr = [];
        if (item.cancelDetail) {
            for (var reason in item.cancelDetail) {
                arr.push({count: item.cancelDetail[reason], text: (reason ? reason : 'UNKNOWN') + ': <b>' + item.cancelDetail[reason] + '</b>'})
            }
            arr.sort(sortCountFunction);
            for (var i in arr) {
                retVal.push(arr[i].text);
            }
        }
        return retVal.join('<br>');
    }

    function sortCountFunction(a, b) {
        if (a['count'] === b['count']) {
            return 0;
        }
        else {
            return (a['count'] < b['count']) ? 1 : -1;
        }
    }

    this.initialize();
}
