@extends('system.layout.main', [
    'ngController' => 'CreatorCategoryController'
])

@section('title')
    <title>Báo cáo sale nhân viên sản phẩm theo danh mục</title>
@endsection

<style>
    .form-control + .chosen-container > .chosen-single {
        border-radius: 3px !important;
        height: 34px !important; */
    border: 1px solid #ced4da;
    }
    .form-group .chosen-container {
        width: 180px !important;
    }

    .form-control + .chosen-container > .chosen-single > span {
        line-height: 34px;
    }
</style>
@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
        $('.dropdown-toggle').dropdown();

        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });

        const urlRestQ = <?=  json_encode(config('pod::enable-service.rest_q_url')); ?>;

        const groupIgnoreColors = <?=  json_encode(config("pod::group-ignore-colors")); ?>;

    </script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="{{ Module::asset('reports/js/creator-category-controller.js') . '?v=' . time() }}" charset="utf-8"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="{{ Module::asset('pod/js/jquery.magnify.js')}}"></script>
    <script src="/system/js/scripts/jquery.datetimepicker.js"></script>
    <script>
        $('[data-magnify=gallery]').magnify()
    </script>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <div class="box no-border">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                            <li class="all-item">
                                <a href="javascript:void(0)" style="cursor: pointer">
                                    Báo cáo sale nhân viên sản phẩm theo danh mục
                                </a>
                            </li>
                        </ul>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        @include('reports::creator-category.filter')
                        @include('reports::creator-category.list')

                        <div class="pull-right" ng-if="jobs.length > 0 && !isLoadingDesign">
                            @include('system.pagination')
                        </div>
                        <!-- </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection