@extends('system.layout.main', [
'ngController' => 'DesignerController'
])
@section('title')
<title>Report designer</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                @include('reports::designer.filters')
                @include('reports::designer.list')
                <div class="pull-right">
                    @view('includes.paginator', [
                    "accessPageId" => "filters.page_id",
                    "accessPagesCount" => "pagesCount",
                    "accessFind" => "find()"
                ])
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    var designers = <?= json_encode($designers) ?>;
    var locates = <?= json_encode($locates) ?>;
</script>
<script src="/modules/reports/js/designer-controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/payment-stats/css/payment-stats.css?v=<?= time() ?>" />
@endsection
