@extends('system.layout.main', [
'ngController' => 'HelpCentralController'
])
@section('title')
<title>Báo cáo nhân viên CSKH</title>
@endsection
@section('content')
<style type="text/css">
    .scroll-container {
        width: 100%; /* Chiều rộng đầy đủ */
        max-height: 400px; /* Đặt chiều cao tối đa mà bạn muốn */
        overflow-x: auto; /* Cho phép cuộn ngang */
        overflow-y: auto; /* Cho phép cuộn dọc nếu cần */
        border: 1px solid #ccc; /* Thêm đường viền nếu muốn */
        padding: 10px; /* Thêm khoảng cách bên trong */
    }

</style>
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <span class="module-title">Tìm kiếm</span>
                @view('reports::help-central.filters')
                <div class="scroll-container">
                    <sp-workflow-chart
                            categories="dataWorkflowChart.categories"
                            assigned="dataWorkflowChart.assigned"
                            done="dataWorkflowChart.done"
                            notresolved="dataWorkflowChart.notresolved"
                            inprocess="dataWorkflowChart.inprocess"
                            auto="dataWorkflowChart.auto"
                            order="dataWorkflowChart.order"
                    ></sp-workflow-chart>
                </div>
                @view('reports::help-central.list')
                @view('reports::help-central.modal')
                <div class="pull-right">
                    @view('includes.paginator', [
                    "accessPageId" => "filters.page_id",
                    "accessPagesCount" => "pagesCount",
                    "accessFind" => "find()"
                ])
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    var users = <?= json_encode($users) ?>;
    var locates = <?= json_encode($locates) ?>;
</script>
<script src="https://code.highcharts.com/stock/highstock.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="/modules/reports/js/help-central-controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/payment-stats/css/payment-stats.css?v=<?= time() ?>" />
@endsection
