@extends('system.layout.main', [
'ngController' => 'ReportPrintingShopController'
])
@section('title')
    <title>Báo cáo theo nhà in</title>
@endsection
@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Báo cáo nhà in
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <ul id="tab-nav-bar" class="nav nav-tabs">
                    <li class="active tab-nav-bar__item" ng-click="changeTab('tab1')" target-table="content-tab1"><a href="#">{{ __('Thống kê nhà in') }}</a></li>
                    <li class="tab-nav-bar__item" ng-click="changeTab('tab2')" target-table="content-tab2"><a href="#">{{ __('Thống kê theo sản phẩm') }}</a></li>
                    <li class="tab-nav-bar__item" ng-click="changeTab('tab3')" target-table="content-tab3"><a href="#">{{ __('Thống kê issue') }}</a></li>
                </ul>
                <div id="content-tab1" class="box no-border table-content">
                    <div class="nav-tabs-custom" style="margin-bottom:0">
                    </div>
                    <div class="box-body">
                        @view('reports::printing-shop.filters')
                        @view('reports::printing-shop.chart')
                        @view('reports::printing-shop.list')
                    </div>
                </div>

                <div id="content-tab2" class="box no-border table-content d-none">
                    <div class="nav-tabs-custom" style="margin-bottom:0">
                    </div>
                    <div class="box-body">
                        @view('reports::printing-shop.filters-tab2')
                        @view('reports::printing-shop.chart-tab2')
                        @view('reports::printing-shop.list-tab2')
                    </div>
                </div>

                <div id="content-tab3" class="box no-border table-content d-none">
                    <div class="nav-tabs-custom" style="margin-bottom:0">
                    </div>
                    <div class="box-body">
                        @view('reports::printing-shop.filters-tab3')
                        @view('reports::printing-shop.chart-tab3')
                        @view('reports::printing-shop.list-tab3')
                        @include('reports::printing-shop.detail-error')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        var locates = <?= json_encode($locates) ?>;
    </script>
    <script src="/modules/reports/js/report-printing-shop-controller.js?v=<?= time() ?>"></script>
    <script src="{{ Module::asset('reports/js/printing.js') . '?v=' . config('sa.version') }}"></script>
    <script src="https://code.highcharts.com/highcharts.js"></script>
@endsection
@section('css')
    <link rel="stylesheet" type="text/css" href="/modules/payment-stats/css/payment-stats.css?v=<?= time() ?>"/>
@endsection
