@extends('system.layout.main', [
'ngController' => 'ResendController'
])
@section('title')
<title>Báo cáo đơn resend</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <span class="module-title">Tìm kiếm</span>
                @view('reports::resend.filters')
                @view('reports::resend.list')
                <div class="pull-right">
                    @view('includes.paginator', [
                    "accessPageId" => "filters.page_id",
                    "accessPagesCount" => "pagesCount",
                    "accessFind" => "find()"
                ])
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
        <?php
        $locales = getModuleLocale();
        ?>
    var dashboardLocalization = <?php echo json_encode($locales); ?>;
</script>
<script src="/modules/reports/js/resend-controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/payment-stats/css/payment-stats.css?v=<?= time() ?>" />
@endsection
