<style>
    .order-list-tracking-icon {
        position: relative;
    }
    .order-list-tracking-icon img {
        cursor: pointer;
        margin: 4px 0;
        display: inline-block;
    }
    .order-list-tootip {
        display: none;
        position: absolute;
        top: -14px;
        top: calc(50% - calc(fit-content / 2));
        right: 100%;
        padding: 8px;
    }
    .order-list-tootip-content {
        background-color: #fff;
        text-align: left;
        padding: 8px;
        border-radius: 6px;
        min-width: 250px;
        font-size: 14px;
        box-shadow: 0 3px 4px -1px rgb(0 0 0 / 20%), 0 5px 10px 0px rgb(0 0 0 / 14%), 0 1px 12px 0px rgb(0 0 0 / 10%);
        position: relative;
    }

    .order-list-tootip-content:after {
        right: -12px;
        top: 17px;
        border: solid transparent;
        content: "";
        height: 0;
        width: 0;
        position: absolute;
        pointer-events: none;
        border-color: rgba(255, 255, 255, 0);
        border-left-color: #fff;
        border-width: 6px;
        margin-top: -6px;
    }

    .order-list-tracking-icon:hover .order-list-tootip {
        display: block;
    }

</style>
<div class="interaction-module-list-wrapper">
    <span class="module-title">Danh sách nhân viên fulfill</span>
    <table class="interaction-module-list-table">
        <thead class="product-advertise-head">
            <tr>
                <th class="col-w30">#</th>
                <th class="col-w100">Nhân viên</th>
                <th class="col-w100">
                    <div class="flex-b align-c align-l flex-e">
                        Tổng đơn hàng
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('totalOrder-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('totalOrder-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'totalOrder-asc' || filters.sort == 'totalOrder-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
                <th class="col-w70">
                    <div class="flex-b align-c align-l flex-e">
                        Thành công
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('successOrder-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('successOrder-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'successOrder-asc' || filters.sort == 'successOrder-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
                <th class="col-w70">
                    <div class="flex-b align-c align-l flex-e">
                        Đang làm
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('processingOrder-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('processingOrder-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'processingOrder-asc' || filters.sort == 'processingOrder-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
                <th class="col-w70">
                    <div class="flex-b align-c align-l flex-e">
                        Đơn refund
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('returnOrder-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('returnOrder-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'returnOrder-asc' || filters.sort == 'returnOrder-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
                <th class="col-w70">
                    <div class="flex-b align-c align-l flex-e">
                        Đơn hủy
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('cancelOrder-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('cancelOrder-desc')"  xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'cancelOrder-asc' || filters.sort == 'cancelOrder-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
                <th class="col-w70">
                    <div class="flex-b align-c align-l flex-e">
                        Giá vốn/doanh thu
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('costAmount-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('costAmount-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'costAmount-asc' || filters.sort == 'costAmount-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
                <th class="col-w80">
                    <div class="flex-b align-c align-l flex-e">
                        Thời gian fulfill
                        <span style="display: inline-flex;" class="flex-dc">
                            <svg ng-click="sort('averageFulfillmentTime-asc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-up-fill sort-image" viewBox="0 0 16 16">
                                <path d="m7.247 4.86-4.796 5.481c-.566.647-.106 1.659.753 1.659h9.592a1 1 0 0 0 .753-1.659l-4.796-5.48a1 1 0 0 0-1.506 0z"/>
                            </svg>
                            <svg ng-click="sort('averageFulfillmentTime-desc')" xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-caret-down-fill sort-image" viewBox="0 0 16 16">
                                <path d="M7.247 11.14 2.451 5.658C1.885 5.013 2.345 4 3.204 4h9.592a1 1 0 0 1 .753 1.659l-4.796 5.48a1 1 0 0 1-1.506 0z"/>
                            </svg>
                        </span>
                        <span style="display: inline-flex; visibility: @{{ filters.sort == 'averageFulfillmentTime-asc' || filters.sort == 'averageFulfillmentTime-desc' ? 'visible' : 'hidden' }}" class="flex-dc">
                            <svg xmlns="http://www.w3.org/2000/svg" width="11" height="11" fill="currentColor" class="bi bi-filter" viewBox="0 0 16 16">
                                <path d="M6 10.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm-2-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"/>
                            </svg>
                        </span>
                    </div>
                </th>
            </tr>
            <tr ng-show="isShowLoading">
                <div class="loading" ng-show="isShowLoading">
                    <div class="loading_line_wrapper">
                        <div class="loading_line">
                            <div class="loading_line_inner loading_line_inner--1"></div>
                            <div class="loading_line_inner loading_line_inner--2"></div>
                        </div>
                    </div>
                </div>
            </tr>
        </thead>
        <tbody class="product-advertise-body">
        
            <tr ng-repeat="item in items">
                <td style="text-align: center;">@{{$index + 1}}</td>
                <td>
                    @{{item.name}}
                </td>
                <td class="column-right">@{{item.totalOrder | number : fractionSize}}</td>
                <td class="column-right">@{{item.successOrder | number : fractionSize}}</td>
                <td class="column-right">@{{item.processingOrder | number : fractionSize}}</td>
                <td class="column-right">@{{item.returnOrder | number : fractionSize}}
                    <i class="fa fa-question-circle order-list-tracking-icon" aria-hidden="true" style="cursor: pointer; visibility: @{{ item.returnOrder > 0 ? 'visible' : 'hidden' }}">
                        <div class="order-list-tootip">
                            <div class="order-list-tootip-content" ng-bind-html="getReturnDetail(item)">
                            </div>
                        </div>
                    </i>
                </td>
                <td class="column-right">@{{item.cancelOrder | number : fractionSize}}
                    <i class="fa fa-question-circle order-list-tracking-icon" aria-hidden="true" style="cursor: pointer; visibility: @{{ item.cancelOrder > 0 ? 'visible' : 'hidden' }}">
                        <div class="order-list-tootip">
                            <div class="order-list-tootip-content" ng-bind-html="getCancelDetail(item)">
                            </div>
                        </div>
                    </i>
                </td>
                <td class="column-right">@{{item.costAmount}}%</td>
                <td class="column-right">@{{item.averageFulfillmentTimeText}}</td>
            </tr>
        </tbody>
    </table>
</div>
