<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

$systemAuth = config('app.system_auth_middleware');
Route::group(['prefix' => 'reports/verifier', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'reports::verifier::index',
        'uses' => 'VerifierController@index',
    ]);
    Route::any('/find', [
        'as' => 'reports::verifier::find',
        'uses' => 'VerifierController@find',
    ]);
});

Route::group(['prefix' => 'reports/resend', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'reports::resend::index',
        'uses' => 'ResendController@index',
    ]);
    Route::any('/find', [
        'as' => 'reports::resend::find',
        'uses' => 'ResendController@find',
    ]);
});


Route::group(['prefix' => 'report/help-central', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'report::help::central::index',
        'uses' => 'HelpCentralController@index',
    ]);
    Route::any('/find', [
        'as' => 'reports::help::central:find',
        'uses' => 'HelpCentralController@find',
    ]);
    Route::post('/build-chart', [
        'as' => 'reports::help::central:build-chart',
        'uses' => 'HelpCentralController@buildChart',
    ]);
});

Route::group(['prefix' => 'report/product', 'middleware' => $systemAuth], function () {

    Route::any('/find', [
        'as' => 'reports::product::find',
        'uses' => 'ProductIdeaController@find',
    ]);
    Route::get('/source', [
        'as' => 'report::product::source::index',
        'uses' => 'ProductController@sourceIndex',
    ]);
    Route::any('/find/source', [
        'as' => 'reports::product::find-source',
        'uses' => 'ProductController@getReportProductSource',
    ]);

    Route::get('/category', [
        'as' => 'report::product::category::index',
        'uses' => 'ProductController@categoryIndex',
    ]);
    Route::any('/find/category', [
        'as' => 'reports::product::find-category',
        'uses' => 'ProductController@getReportProductCategory',
    ]);

    Route::get('/recent-sale', [
        'as' => 'report::product::recent-sale::index',
        'uses' => 'ProductController@recentSaleIndex',
    ]);

    Route::any('/find/recent-sale', [
        'as' => 'reports::product::find-recent-sale',
        'uses' => 'ProductController@getRecentProductHasSale',
    ]);
});

Route::group(['prefix' => 'report/designer', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'report::designer::index',
        'uses' => 'DesignerController@index',
    ]);
    Route::any('/find', [
        'as' => 'reports::designer:find',
        'uses' => 'DesignerController@find',
    ]);
});
Route::group(['prefix' => 'report/designer'], function () {
    Route::any('/build-report-product-design', [
        'as' => 'reports::designer:build-report',
        'uses' => 'DesignController@buildReportProductDesign', 
    ]);
});

Route::group(['prefix' => 'report/design', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'report::design::index',
        'uses' => 'DesignController@index',
    ]);
    Route::any('/find', [
        'as' => 'reports::design:find',
        'uses' => 'DesignController@find',
    ]);

    Route::any('/find/category', [
        'as' => 'reports::design:find-category',
        'uses' => 'DesignController@reportCategory',
    ]);
});

Route::group(['prefix' => 'report/creator', 'middleware' => $systemAuth], function () {
    Route::get('/category', [
        'as' => 'report::creator::category::index',
        'uses' => 'CreatorController@indexCreatorCategory',
    ]);

    Route::get('/revenue', [
        'as' => 'report::creator::revenue::index',
        'uses' => 'CreatorController@indexCreatorRevenue',
    ]);
    Route::get('/v2/revenue', [
        'as' => 'report::creator::v2::revenue::index',
        'uses' => 'CreatorController@indexCreatorRevenueV2',
    ]);

    Route::any('find/category', [
        'as' => 'reports::creator:category::find',
        'uses' => 'CreatorController@findCreatorCategory',
    ]);
});
Route::group(['prefix' => 'report/creator'], function () {
    Route::any('/find/revenue', [
        'as' => 'reports::creator:revenue',
        'uses' => 'CreatorController@findReportCreatorRevenue',
    ]);
    Route::any('/v2/find/revenue', [
        'as' => 'reports::creator:revenue',
        'uses' => 'CreatorController@findReportCreatorRevenueV2',
    ]);
});


Route::group(['prefix' => 'summary'], function () {
    Route::get('/product/count', [
        'as' => 'summary::product::count',
        'uses' => 'HomeController@buildSummaryCountProducts',
    ]);
    Route::get('/content-product/count', [
        'as' => 'summary::content-product::count',
        'uses' => 'HomeController@buildSummaryCountContentProducts',
    ]);
    Route::get('/order', [
        'as' => 'summary::order',
        'uses' => 'HomeController@buildSummaryRevenueAndCost',
    ]);
    Route::get('/actor/order', [
        'as' => 'summary::order::actor',
        'uses' => 'HomeController@buildSummaryCreatorProductRevenue',
    ]);
});

Route::group(['prefix' => 'report/order', 'middleware' => $systemAuth], function () {
    Route::get('/refund', [
        'as' => 'report::order::refund::index',
        'uses' => 'OrderController@index',
    ]);
    Route::get('/find', [
        'as' => 'report::order::refund::find',
        'uses' => 'OrderController@findOrderRefund',
    ]);
});

Route::group(['prefix' => 'report/printing-shop', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'report::printing-shop::index',
        'uses' => 'PrintingShopController@index',
    ]);

    Route::get('/get-category', [
        'uses' => 'PrintingShopController@getCategory',
    ]);

    Route::get('/get-printing', [
        'uses' => 'PrintingShopController@getPrinting',
    ]);

    Route::get('/find-chart', [
        'uses' => 'PrintingShopController@findChart',
    ]);

    Route::get('/find-average', [
        'uses' => 'PrintingShopController@findAverage',
    ]);

    Route::get('/find-percent-status', [
        'uses' => 'PrintingShopController@findPercentStatus',
    ]);

    Route::get('/find-issue', [
        'uses' => 'PrintingShopController@findIssue',
    ]);
});

Route::group(['prefix' => 'report/predict', 'middleware' => $systemAuth], function () {
    Route::get('/product-has-sale', [
        'as' => 'report::predict::product-has-sale::index',
        'uses' => 'PredictController@indexProductHasSale',
    ]);

    Route::post('/get-sale-data', [
        'uses' => 'PredictController@getSaleData',
    ]);
    Route::get('/get-predict-report', [
        'uses' => 'PredictController@getPredictReport',
    ]);
});

Route::group(['prefix' => 'report/performance/design', 'middleware' => $systemAuth], function () {
    Route::get('/', [
        'as' => 'report::design::performance::index',
        'uses' => 'ReportDesignController@indexReportDesign',
    ]);
    Route::get('/count-design', [
        'as' => 'report::design::count-design',
        'uses' => 'ReportDesignController@getCountDesign',
    ]);
    Route::get('/conversion-rate', [
        'as' => 'report::design::conversion-rat',
        'uses' => 'ReportDesignController@buildConversionRate',
    ]);
    Route::get('/ads', [
        'as' => 'report::design::ads',
        'uses' => 'ReportDesignController@countAdsPerformance',
    ]);
});

Route::group(['prefix' => 'report/performance/design'], function () {
    Route::get('/need-design', [
        'as' => 'report::design::need-design',
        'uses' => 'ReportDesignController@getCountNeedDesign',
    ]);
    Route::get('/no-need-design/conversion-rate', [
        'as' => 'report::design::no-need-design-conversion-rate',
        'uses' => 'ReportDesignController@getConversionRateNoNeedDesign',
    ]);
});
