<?php

namespace Modules\Reviews\Controllers;

use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Modules\Reviews\Controllers\Controller;
use Module;
use Modules\Reviews\Models\Category;
use Modules\Reviews\Models\Comment;
use Modules\Reviews\Models\Option;
use Modules\Reviews\Models\Post;
use Modules\Reviews\Models\Product;
use Modules\Reviews\Models\ProductNCategory;
use Illuminate\Support\Facades\Route;
use Modules\Reviews\Models\CommentLib;

class CommentLibController extends Controller
{

    protected $settingKey = 'seeding.review.setting';
    public function __construct()
    {
    }

    public function storeComment(Request $request)
    {
        $responseData = [
            'status' => 'fail',
            'result' => []
        ];

        //successful

        $comments = $request->input('comments');
        if ($comments) {
            foreach ($comments as $valueComment) {
                if (isset($valueComment['id']) && $valueComment['id']) {
                    $comment = CommentLib::find($valueComment['id']);
                    if ($comment) {
                        $comment->fill($valueComment);
                    }
                } else {
                    $comment = new CommentLib();
                    $comment->fill($valueComment);
                }

                if($comment->save()) {
                   $responseData['status'] = 'successful';
                    $responseData['result'][] = $comment;
                }
            }
        }

        return $responseData;
    }

    public function getComment($commentIds)
    {
        $responseData = [
            'status' => 'fail',
            'result' => []
        ];

        $commentIds = explode(',', $commentIds);
        $comments = Comment::whereIn('id', $commentIds)->get();

        if ($comments && count($comments))
            $responseData['status'] = 'successful';

        foreach ($comments as $comment) {
            $target = null;
            if ($comment->target_type == 'PRODUCT') {
                $target = Product::select(['id', 'sku', 'name', 'slug'])
                    ->find($comment->target_id);
            } else if ($comment->target_type == 'POST') {
                $target = Post::select(['id', 'name', 'slug'])
                    ->find($comment->target_id);
            }

            if ($target) {
                $responseData['result'][$comment->id] = $target;
            }
        }

        return $responseData;
    }

    public function find(Request $request)
    {
        $responseData = [
            'status' => 'fail',
            'result' => []
        ];

        $filters = $request->input('filters');
        $pageId = $request->input('page_id');
        $filters = json_decode($filters, true);

        $query = CommentLib::query();
        if (isset($filters['rating']) && $filters['rating']) {
            $query->where('rating', $filters['rating']);
        }
        if (isset($filters['target_type']) && $filters['target_type']) {
            $query->where('target_type', $filters['target_type']);
        }
        if (isset($filters['order'])) {
            foreach ($filters['order'] as $key => $value) {
                $query->orderBy($key, $value);
            }
        } else {
            $query->orderBy('id', 'desc');
        }

        if (isset($filters['search']) && $filters['search']) {
            $query->where(function ($query) use ($filters) {
                $query->where('fullname', 'like', '%' . $filters['search'] . '%')
                    ->orWhere('email', 'like', '%' . $filters['search'] . '%')
                    ->orWhere('title', 'like', '%' . $filters['search'] . '%')
                    ->orWhere('content', 'like', '%' . $filters['search'] . '%');
            });
        }

        $total = $query->count();
        if (!isset($filters['pageSize']) || $filters['pageSize'] <= 0) {
            $filters['pageSize'] = 100;
        }
        $query->limit($filters['pageSize']);

        if (isset($pageId)) {
            $query->offset($pageId * $filters['pageSize']);
        }

        $query->with('category');

        $result = $query->get();
        $meta = $this->getMetaData($filters, $total);

        if ($result) {
            $responseData = [
                'status' => 'successful',
                'result' => $result,
                'meta' => $meta,
            ];
        }

        return $responseData;
    }

    public function getMetaData($filters, $total)
    {
        $pageId = 0;
        $pageSize = 20;
        if (!empty($filters['pageSize'])) {
            $pageSize = $filters['pageSize'];
        }
        if (!empty($filters['pageId'])) {
            $pageId = $filters['pageId'];
        }
        $meta = [
            'page_id' => $pageId,
            'page_size' => $pageSize,
            'page_count' => 0,
            'has_next' => false,
            'total_count' => $total,
        ];
        $meta['page_count'] = ceil($total / $pageSize);
        if ($pageId < $meta['page_count'] - 1) {
            $meta['has_next'] = true;
        }

        return $meta;
    }

    public function deleteComment($commentIds)
    {
        $routeParameters = Route::current()->parameters();
        $commentIds = $routeParameters['commentId'];

        $responseData = [
            'status' => 'fail',
            'result' => []
        ];

        $commentIds = explode(',', $commentIds);
        $deleteComments = CommentLib::whereIn('id', $commentIds)->delete();
        if ($deleteComments) {
            $responseData['status'] = 'successful';
            $responseData['result'] = $deleteComments;
        }

        return $responseData;
    }

    public function loadSeedingSetting()
    {
        return Option::query()->where('key', $this->settingKey)->first(['id', 'value', 'type']);
    }

    public function storeSeedingSetting(Request $request)
    {
        $data = $request->input('setting');
        $setting = null;
        if ($data) {
            $setting = $this->loadSeedingSetting();
            if (!$setting) {
                $setting = new Option();
            }
            $setting->fill([
                'key' => $this->settingKey,
                'value' => json_encode($data)
            ]);
            $setting->save();
        }
        return $setting;
    }

    public function markFakeComments()
    {
        // list email fake
        $fakeEmails = DB::table('comment_lib')->select('email')->groupBy('email')->pluck('email')->toArray();

        // get comment match fake condition
        $comments = DB::table('comment')
            ->whereNull('email')
            ->orWhere('email', '')
            ->update(['user_id' => -1]);

        $comments += DB::table('comment')
            ->whereIn('email', $fakeEmails)
            ->update(['user_id' => -1]);

        return [
            'affected_rows' => $comments
        ];
    }
}
