<?php

namespace Modules\Reviews\Controllers;

use Illuminate\Http\Request;
use Modules\Reviews\Controllers\Controller;
use Module;

class HomeController extends Controller
{
    public function __construct()
    {        
        Module::onView("content", function() {
            return "This is content view from Reviews Module HomeController";
        }, 5);
    }

    public function index(Request $request)
    {
        $message = config("reviews::app.message");
        return view('reviews::home.welcome', [
            'message' => $message,
        ]);
    }

    public function manager(Request $request)
    {
        return view('reviews::home.manager', []);
    }

    public function library(Request $request)
    {
        return view('reviews::home.library', []);
    }
}
