<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCommentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
    if (!Schema::hasTable('comment')) {
        Schema::create('comment', function (Blueprint $table) {
            $table->increments('id');
            $table->string('full_name', 255)->default('');
            $table->string('email', 255)->default('');
            $table->string('title', 255)->nullable()->default('');
            $table->integer('user_id')->nullable();
            $table->string('session_id', 200)->nullable();
            $table->text('content')->nullable();
            $table->unsignedInteger('parent_id')->nullable();
            $table->integer('target_id')->nullable();
            $table->enum('target_type', ['PRODUCT', 'POST'])->default('PRODUCT');
            $table->unsignedInteger('reply_count')->nullable()->default(0);
            $table->unsignedInteger('rating')->nullable()->default(0);
            $table->text('images')->nullable();
            $table->enum('status', ['ACTIVE', 'PENDING', 'BLOCK'])->nullable()->default('ACTIVE');
            $table->dateTime('created_at')->nullable();
            $table->tinyInteger('is_replied')->default(0);
            $table->dateTime('updated_at')->nullable();
            $table->index('parent_id', 'parent');
            $table->index('created_at', 'created_at');
            $table->integer('order_id')->nullable();
            
            $table->charset = 'utf8';
            $table->collation = 'utf8_unicode_ci';
        });
    }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('comment');
    }
}
