<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateSbCommentLibTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('comment_lib')) {
            Schema::create('comment_lib', function (Blueprint $table) {
                $table->increments('id');
                $table->string('fullname', 255)->nullable();
                $table->string('title', 255)->nullable();
                $table->string('email', 255)->nullable();
                $table->text('content')->nullable();
                $table->float('rating')->nullable();
                $table->string('category_slug', 255)->nullable();
                $table->integer('category_id')->nullable();
                $table->text('images')->nullable();

                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('comment_lib');
    }
}
