<?php
namespace Modules\Reviews\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Modules\Ads\Models\CategoryMeta;
use Modules\Ads\Models\ProductNCategory;

class Category extends Model {
    protected $table = "category";
    protected $guarded = ['id'];

    const TYPE_PRODUCT = 'PRODUCT';
    const TYPE_POST = 'POST';

    protected $fillable = [
        'name', 'type', 'is_hidden', 'image_url', 'big_image_url', 'description', 'slug', 'sorder', 'parent_id', 'is_display_home_page'
    ];

    protected $appends = [

    ];

    public function parents() {
        return $this->belongsTo('\App\Models\Category', 'parent_id');
    }

    public function getLftName()
    {
        return '_lft';
    }

    public function getRgtName()
    {
        return '_rgt';
    }

    public function getParentIdName()
    {
        return 'parent_id';
    }

    public function getDescendantsAttribute()
    {
        $descendants = $this->where('_lft', '>', $this->_lft)
            ->where('_rgt', '<', $this->_rgt)
            ->get(['id', 'name', 'slug', 'type', '_lft', '_rgt', 'depth', 'parent_id']);

        foreach ($descendants as $descendant) {
            $descendant->append('depth');
        }
        
        return $descendants;
    }

    public function getDepthAttribute()
    {    
        $depth = $this->where('_lft', '<', $this->_lft)
        ->where('_rgt', '>', $this->_rgt)->count();
        return $depth + 1;
    }

    public function categoryMetas() {
        return $this->hasMany(CategoryMeta::class, 'category_id');
    }

    public function scopeGetChildCategories($query, array $ids) {
        return $query->whereIn('parent_id', $ids)->get();
    }
}
