<?php
namespace Modules\Reviews\Models;
use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    protected $table = 'comment';

    protected $fillable = [
        'full_name',
        'email',
        'title',
        'user_id',
        'session_id',
        'content',
        'parent_id',
        'target_id',
        'target_type',
        'reply_count',
        'rating',
        'images',
        'status',
        'is_replied',
        'order_id',
        'is_verified',
        'created_at',
        'updated_at',
        'sort_id',
        'is_pin'
    ];

    public function parent()
    {
        return $this->hasOne(Comment::class, 'id', 'parent_id');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
}
