<?php
namespace Modules\Reviews\Models;
use Illuminate\Database\Eloquent\Model;

class CommentLib extends Model
{
    public $timestamps = false;
    protected $table = 'comment_lib';

    protected $fillable = [
        'fullname',
        'email',
        'title',
        'content',
        'rating',
        'images',
        'category_id'
    ];

    public function category()
    {
        return $this->hasOne(Category::class, 'id', 'category_id');
    }
}
