system.controller("ReviewLibManagerController", ReviewLibManagerController);
function ReviewLibManagerController($scope, $http, $rootScope, Upload, $timeout) {

    $scope.baseController = this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);

    const UPDATE_MODE = 'update';
    const CREATE_MODE = 'create';

    $scope.locale = '';
    if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
        $scope.locale = '/' + localePrefix;
    }

    $scope.pagination = {
        current_page: 1,
        number_page: 1
    }

    $scope.filters = {
        pageSize: 100
    }

    $scope.state = {
        search_string: null,
        old_search_string: null
    }

    $scope.status = {
        is_fetching_comments: true,
        is_fetching_targets: true,
        is_changing_target: false
    }

    $scope.seedingSettings = {}

    $scope.commentStatuses = [
        'ACTIVE', 'PENDING', 'BLOCK'
    ];

    $scope.timeOut = setTimeout(() => { }, 0);
    $scope.comments = [];
    $scope.commentIds = [];

    $scope.initialize = function () {
        fetchComments();
        fetchCategories();

        $('#modalCommentForm').on('shown.bs.modal', function () {
            $("#inputFullname").focus();

            if (document.getElementById("boxCommentContent")) {
                $scope.moreLessContent('close');
                if (!checkOverflow(document.getElementById("boxCommentContent"))) {
                    document.getElementById("moreLessBtn").style.display = 'none';
                }
            }
        });

        $('#modalCommentForm').on('hidden.bs.modal', function () {
            $scope.status.is_changing_target = false;
            $scope.moreLessContent('close');
        });

        // build seeding setting
        // $scope.seedingSettings

    };

    /*function loadSeedingSetting()
    {
        const settingKey = 'SEDDING_REVIEW_SETTING';
        $http({
            method: 'get',
            url: base_api_url + '/option?filters=key=' + settingKey,
        }).then(function success(response) {
            if (response.data.status == 'successful') {

            } else {
                toastr.error('Error load seeding setting!');
            }
        });
    }*/

    function fetchComments() {
        $scope.commentIds = [];
        $scope.status.is_fetching_comments = true;
        let filters = angular.copy($scope.filters);

        if (filters.created_from) {
            filters.created_from = $scope.vietnameseTimeToSQLTime(filters.created_from);
        }

        if (filters.created_to) {
            filters.created_to = $scope.vietnameseTimeToSQLTime(filters.created_to);
        }

        $http({
            method: 'get',
            url: '/reviews/fetch-comment-lib',
            params: {
                filters: JSON.stringify(filters),
                page_id: $scope.pagination.current_page - 1
            }
        }).then(function success(response) {
            $scope.status.is_fetching_comments = false;
            if (response.data.status == 'successful') {
                $scope.comments = response.data.result;
                standardize();
                /* mapTargets(); */

                $scope.pagination.number_page = response.data.meta.page_count;
                if ($scope.pagination.number_page < $scope.pagination.current_page)
                    $scope.pagination.current_page = 1;

            } else {
                toastr.error('Error fetch comments!');
            }
        });
    }

    $scope.fetchComments = $scope.fetch = fetchComments;

    function standardize() {
        for (let index = 0; index < $scope.comments.length; index++) {
            let commentImages = [];
            if ($scope.comments[index].images) {
                commentImages = JSON.parse($scope.comments[index].images);
            }

            $scope.comments[index].images = commentImages;
        }
    }

    $scope.changeTarget = function (item) {
        $scope.currentComment.target = item;
        $scope.state.search_string = '';
        $scope.status.is_changing_target = false;
        $scope.resultSearch = [];

        $('#modalCommentForm').animate({ scrollTop: 0 }, 0);
    }

    $scope.removeAllFilters = function () {
        $scope.filters = {};
        fetchComments();
    };

    function mapTargets() {
        let commentIds = pluckCommentIds();
        $timeout(function () {
            $http({
                method: 'get',
                url: '/reviews/load-target/' + commentIds.join(','),
            }).then(function success(response) {
                if (response.data.status == 'successful') {
                    $scope.status.is_fetching_targets = false;

                    let targets = response.data.result;
                    $scope.comments.forEach(comment => {
                        if (typeof targets[comment.id] != 'undefined' && targets[comment.id]) {

                            if (comment.target_type == 'PRODUCT') {
                                targets[comment.id].url = '/' + targets[comment.id].slug + '-p' + targets[comment.id].id + '.html';
                            } else if (comment.target_type == 'POST') {
                                targets[comment.id].url = '/' + targets[comment.id].slug + '-n' + targets[comment.id].id + '.html';
                            }

                            comment.target = targets[comment.id];
                        }
                    });

                } else {
                    toastr.error('Error fetch mapTargets!');
                }
            });
        })
    }

    /* function standardizeSearchResult(result) {
        let finalResult = [];
        for (let index = 0; index < result.length; index++) {
            let item = result[index];

            let name = 

            finalResult.push({
                name: (item.name) ?
            });
        }

        return result;
    } */

    function fetchCategories() {
        $http({
            method: 'get',
            url: base_api_url + '/categories',
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                $scope.categories = response.data.result;
            } else {
                toastr.error('Error fetchCategories!');
            }
        });
    }

    function searchProduct() {
        $scope.status.is_searching = true;

        if ($scope.state.search_string == '') {
            $timeout(function () {
                $scope.resultSearch = [];
                $scope.status.is_searching = false;
            });
        } else {
            $http({
                method: 'get',
                url: base_api_url + '/product?page_id=0&page_size=10&search=' + $scope.state.search_string,
            }).then(function success(response) {
                $scope.status.is_searching = false;
                if (response.data.status == 'successful') {
                    $scope.resultSearch = response.data.result;
                } else {
                    toastr.error('Error searchProduct!');
                }
            });
        }
    }

    function searchPost() {
        $scope.status.is_searching = true;

        if ($scope.state.search_string == '') {
            $timeout(function () {
                $scope.resultSearch = [];
                $scope.status.is_searching = false;
            });
        } else {
            $http({
                method: 'get',
                url: base_api_url + '/post?page_id=0&page_size=10&filters=name~' + $scope.state.search_string,
            }).then(function success(response) {
                $scope.status.is_searching = false;
                if (response.data.status == 'successful') {
                    $scope.resultSearch = response.data.result;
                } else {
                    toastr.error('Error searchPost!');
                }
            });
        }
    }

    function pluckCommentIds() {
        let commentIds = angular.copy($scope.commentIds);
        for (let index = 0; index < $scope.comments.length; index++) {
            if (!commentIds.includes($scope.comments[index].id))
                commentIds.push($scope.comments[index].id);
        }
        $scope.commentIds = commentIds;

        if (!$scope.$$phase) {
            $scope.$apply();
        }

        return commentIds;
    }

    $scope.openForm = function (comment = null, mode = UPDATE_MODE) {
        $scope.mode = mode;
        if (comment) {
            $scope.currentComment = comment;
        } else {
            $scope.currentComment = {
                images: [],
                rating: 5,
                category_id: -1
            };
        }
        $scope.baseController.openDialogModal('#modalCommentForm');
    };

    $scope.openFormImport = function () {
        $scope.baseController.openDialogModal('#modalCommentImport');
    };

    $scope.openFormSetting = function () {
        $scope.baseController.openDialogModal('#modalSeedingSetting');
    };

    $scope.replyComment = function (comment) {
        $scope.commentIds = [];
        $scope.mode = CREATE_MODE;
        $scope.currentComment = {
            images: [],
            status: 'ACTIVE',
            target_type: comment.target_type,
            parent: comment,
            target: comment.target,
            target_id: comment.target_id,
            parent_id: comment.id,
            rating: 5
        };
        $scope.baseController.openDialogModal('#modalCommentForm');
    }

    $scope.importComments = async function (files) {

        var locale = '';
        if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
            locale = '/' + localePrefix;
        }

        $scope.importingComments = true;
        if (files && files[0]) {
            let file = files[0];
            if (['csv', 'xls', 'xlsx'].includes(file.name.split('.').pop())) {

                var formData = new FormData();
                formData.append("comments", file);

                var request = new XMLHttpRequest();
                request.open("POST", locale + '/reviews/import-lib');
                request.onload = function (e) {

                    var res = JSON.parse(this.responseText);
                    if(res.status == 'successful') {
                        toastr.success('Imported!');
                        fetchComments();
                    } else {
                        toastr.error('Something went wrong please try again!');
                    }

                    $scope.$applyAsync(function () {
                        $scope.importingComments = false;
                    });
                    
                };
                request.send(formData);

            } else {
                toastr.warning('Extention of file invalid!');
            }
        }
    };

    $scope.uploadImages = async function (files) {
        if (files) {

            if (files.length + $scope.currentComment.images.length > 5) {
                toastr.error('Too much images!');
                return false;
            }

            try {
                let imagesUploaded = [];
                
                $scope.uploading = true;
                imagesUploaded = await $scope.uploads(files);

                if (imagesUploaded.length) {
                    $scope.$applyAsync(function () {
                        $scope.currentComment.images = $scope.currentComment.images.concat(imagesUploaded);
                    });
                }

                $scope.uploading = false;

            } catch (error) {
                $scope.uploading = false;
                console.log(error);
            }

            $scope.$apply();
        }
    };

    $scope.removeImage = function (idx) {
        var param = {
            title: 'Xóa ảnh',
            text: 'xóa ảnh này',
            arg: { idx: idx }
        };
        $scope.callConfirmModal(param, function (arg) {
            $scope.$apply(function () {
                $scope.currentComment.images.splice(arg.idx, 1);
            });
        });
    }

    $scope.deleteComment = function (comment) {
        var param = {
            title: 'Delete Item',
            customText: 'Confirm to delete this item!',
            confirmButtonText: 'Ok',
            cancelButtonText: 'No',
            arg: { id: comment.id }
        };
        $scope.callConfirmModal(param, function (arg) {
            $http({
                method: 'delete',
                url: '/reviews/delete-comment-lib/' + arg.id,
            }).then(function success(response) {
                if (response.data.status == 'successful') {
                    toastr.success('Deleted!');
                    fetchComments();
                } else {
                    toastr.error('Error delete comment!');
                }
            });


        });
    }

    $scope.addlbr = function (content) {
        if(!content) content = '';
        return content.replace(/\n/g, "<br />");
    }

    $scope.quickUpdate = function (comment, updateData) {
        comment[updateData.key] = updateData.value;
        storeComment([comment], function () {
            fetchComments();
            toastr.success('Saved!');
        });
    }

    $scope.save = function () {
        let data = angular.copy($scope.currentComment);
        $scope.loaddingButton('#btnSaveComment', 'Saving . . .');

        if (validateSaveData(data)) {
            storeComment([data], function () {
                fetchComments();
                $scope.stopLoaddingButton('#btnSaveComment');
                toastr.success('Saved!');

                $('#modalCommentForm').modal('hide')
            });
        } else {
            $scope.stopLoaddingButton('#btnSaveComment');
        }

    }

    function validateSaveData(data) {
        let isValid = true;
        if (typeof data.content == 'undefined' || !data.content) {
            isValid = false;
            toastr.warning('Please enter content!');
        }
        if (typeof data.fullname == 'undefined' || !data.fullname) {
            isValid = false;
            toastr.warning('Please enter fullname!');
        }
        if (data.rating > 5 || data.rating < 0) {
            isValid = false;
            toastr.warning('Score value invalid!');
        }

        return isValid;
    }

    function storeComment(comments, callback) {

        for (let index = 0; index < comments.length; index++) {
            if (typeof comments[index].images != 'undefined') {
                comments[index].images = JSON.stringify(comments[index].images);
            }
        }

        $http({
            method: 'post',
            url: '/reviews/store-comments-lib',
            data: {
                comments
            }
        }).then(function success(response) {
            if (response.data.status == 'successful') {
                callback(response);
            } else {
                toastr.error('Error store comments!');
            }
        });
    }

    $scope.changeKeywordTarget = function (forceSearch = false) {
        if (
            forceSearch
            || !$scope.state.old_search_string
            || $scope.state.old_search_string != $scope.state.search_string
        ) {
            $scope.state.old_search_string = angular.copy($scope.state.search_string);

            $scope.state.is_typing = true;
            clearTimeout($scope.timeOut);
            $scope.timeOut = setTimeout(() => {
                $scope.state.is_typing = false;
                searchTarget();
            }, 500);
        }
    }

    function searchTarget() {
        if ($scope.currentComment.target_type == 'PRODUCT') {
            searchProduct();
        } else if ($scope.currentComment.target_type == 'POST') {
            searchPost();
        }
    }

    $scope.moreLessContent = function (mode = 'auto') {
        let boxCommentContent = document.getElementById("boxCommentContent");
        if (boxCommentContent) {
            switch (mode) {
                case 'close':
                    removeClass(boxCommentContent, 'show-more');
                    break;
                case 'open':
                    addClass(boxCommentContent, 'show-more');
                    break;
                default:
                    if (hasClass(boxCommentContent, 'show-more')) {
                        removeClass(boxCommentContent, 'show-more');
                    } else {
                        addClass(boxCommentContent, 'show-more');
                    }
                    break;
            }
        }
    }

    function hasClass(ele, cls) {
        return !!ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
    }

    function addClass(ele, cls) {
        if (!hasClass(ele, cls)) ele.className += " " + cls;
    }

    function removeClass(ele, cls) {
        if (hasClass(ele, cls)) {
            var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');
            ele.className = ele.className.replace(reg, ' ');
        }
    }

    function checkOverflow(el) {
        var curOverflow = el.style.overflow;

        if (!curOverflow || curOverflow === "visible")
            el.style.overflow = "hidden";

        var isOverflowing = el.clientWidth < el.scrollWidth
            || el.clientHeight < el.scrollHeight;

        el.style.overflow = curOverflow;

        return isOverflowing;
    }

    $scope.range = function (min, max, step) {
        step = step || 1;
        var input = [];
        for (var i = min; i <= max; i += step) {
            input.push(i);
        }
        return input;
    };

    $scope.initialize();
}