
let hoverFlag = false;
document.addEventListener("DOMContentLoaded", function (event) {
    var xhrLoadBestReviews = new XMLHttpRequest();
    xhrLoadBestReviews.addEventListener("readystatechange", function () {
        if (this.readyState === 4) {
            try {
                let response = JSON.parse(this.responseText);
                if (response.status == 'successful' && response.result.length) {
                    let reviews = response.result;
                    let index = 1;

                    renderBestReviews(reviews[0]);
                    setInterval(() => {
                        if (!hoverFlag) {
                            renderBestReviews(reviews[index]);
                            index++;
                            if (reviews.length == index) index = 0;
                        }
                    }, 10000);
                }
            } catch (error) {
                console.log(error);
            }

        }
    });

    $('.best-commented-list')
        .on("mouseenter", function () {
            hoverFlag = true;
        })
        .on("mouseleave", function () {
            hoverFlag = false;
        });

    function isTouchDevice() {
        return (('ontouchstart' in window) ||
            (navigator.maxTouchPoints > 0) ||
            (navigator.msMaxTouchPoints > 0));
    }

    if (isTouchDevice()) {
        $(document).on('click', '.best-commented-item', function () {
            window.location.href = $(this).find('a').attr('href');
        })
    }

    function renderBestReviews(review) {
        if (review.target && review.full_name) {
            if ($('.best-commented').hasClass('hidding'))
                $('.best-commented').removeClass('hidding');

            let transTemplate = $('.best-commented-item').data('trans');
            let transTemplate02 = $('.best-commented-item').data('trans02');

            let name = review.full_name;
            if (transTemplate)
                name = transTemplate.replace('%s', review.full_name);

            let productUrl = '/' + review.target.slug + '-p' + review.target.id;
            if (typeof localePrefix != 'undefined' && localePrefix) {
                productUrl = '/' + localePrefix + productUrl
            }

            $('.best-commented-item').fadeOut('fast', function () {
                $('.best-commented-item').html(`
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chat-dots" viewBox="0 0 16 16">
                        <path d="M5 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm4 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0zm3 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2z"/>
                        <path d="m2.165 15.803.02-.004c1.83-.363 2.948-.842 3.468-1.105A9.06 9.06 0 0 0 8 15c4.418 0 8-3.134 8-7s-3.582-7-8-7-8 3.134-8 7c0 1.76.743 3.37 1.97 4.6a10.437 10.437 0 0 1-.524 2.318l-.003.011a10.722 10.722 0 0 1-.244.637c-.079.186.074.394.273.362a21.673 21.673 0 0 0 .693-.125zm.8-3.108a1 1 0 0 0-.287-.801C1.618 10.83 1 9.468 1 8c0-3.192 3.004-6 7-6s7 2.808 7 6c0 3.193-3.004 6-7 6a8.06 8.06 0 0 1-2.088-.272 1 1 0 0 0-.711.074c-.387.196-1.24.57-2.634.893a10.97 10.97 0 0 0 .398-2z"/>
                    </svg>
                    <a target="_blank" href="${productUrl}">
                        <span style="color: #333">${transTemplate02}</span>
                        ${review.target.name}
                    </a>
                    <span class="best-comment-action">${name}</span>
                    <small>"${review.content}"</small>
                `);
                setTimeout(() => {
                    $('.best-commented-item').slideDown();
                }, 100);
            });
        }
    }

    let bestReviewUrl = "/reviews/best-reviews";
    if (typeof localePrefix != 'undefined' && localePrefix) {
        bestReviewUrl = '/' + localePrefix + bestReviewUrl
    }
    xhrLoadBestReviews.open("GET", bestReviewUrl);
    xhrLoadBestReviews.send();
});