function isValidEmail(email) {
    const regex = /^[\w\.]+@[\w\.]+\.\w{2,5}$/;
    return email != null && email.match(regex) != null;
}

const TARGETS = {
    thisItem: 1,
    thisShop: 2
}

const safeApply = ($scope) => {
    if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
        $scope.$apply();
    }
}

productPageModule.service('DataService', function($rootScope, $window) {
    var shareData = {};
    $window.rootScopes = $window.rootScopes || [];
    $window.rootScopes.push($rootScope);

    if (!!$window.sharedService) {
        return $window.sharedService;
    }

    $window.sharedService = {
        change: function(key, value) {
            shareData[key] = value;
            angular.forEach($window.rootScopes, function(scope) {
                if (!scope.$$phase) {
                    scope.$apply();
                }
            });
        },
        get: function(key) {
            return shareData[key];
        }
    }

    return $window.sharedService;
});

productPageModule.controller('ReviewController', function($scope, $http, DataService) {

    $scope.productId = $('#productId').val();
    $scope.totalCount = 0;
    $scope.avgRating = 0;
    $scope.websiteMeta = {};
    $scope.target = TARGETS.thisItem;
    $scope.targets = TARGETS;
    $scope.overAll = {
        item: null,
        shop: null
    }
    $scope.loadRatingCount = true;
    $scope.countByRatingWebsite = [
        {
            "rating": 5,
            "count": 0,
            "percent": 0,
        },
        {
            "rating": 4,
            "count": 0,
            "percent": 0,
        },
        {
            "rating": 3,
            "count": 0,
            "percent": 0,
        },
        {
            "rating": 2,
            "count": 0,
            "percent": 0,
        },
        {
            "rating": 1,
            "count": 0,
            "percent": 0,
        }
    ];

    const avgRatingCache = {value: 0};

    function init() {
        if (!isNaN($scope.productId)) {
            $scope.getWebsiteCommentRating(true);
            $scope.websiteMeta = () => DataService.get('websiteMeta');
        } else {
            window.addEventListener('chooseProductSku', e => {
                const sku = e.detail.sku();
                changeProduct(sku.product_id)
            });
        }

        DataService.change('target', $scope.target);
    }

    function changeProduct(productId) {
        $scope.productId = productId;
        init();
    }

    $scope.getAvgRaring = () => {
        return avgRatingCache.value;
    }

    $scope.changeTarget = function(target) 
    {
        $scope.target = target;
        $scope.getWebsiteCommentRating();

        DataService.change('target', $scope.target);
        DataService.get('changeTarget')();

        // apply overall
        if ($scope.target === TARGETS.thisItem && $scope.overAll.item) {
            $scope.countByRatingWebsite = $scope.overAll.item.data;
        } else if ($scope.overAll.shop) {
            $scope.countByRatingWebsite = $scope.overAll.shop.data;
        }

        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
    }

    $scope.openForm = function() {
        $('.module-review-form-wrapper').addClass('form-show');
        // $([document.documentElement, document.body]).animate({
        //     scrollTop: $("#moduleReviewForm").offset().top - 120
        // }, 150);
    }

    $scope.getPercentToFix = function(number) {
        if (number % 1 != 0) number = Math.round(number);
        return number;
    }

    $scope.getWebsiteCommentRating = async (firstCall) => 
    {
        $scope.loadRatingCount = true;

        if ($scope.target == 1) 
        {
            $scope.countByRatingWebsite = await getProductRating();
        } else {
            $scope.countByRatingWebsite = await getShopRating();
        }

        const _count = {total: 0, count: 0};
        for (const key in $scope.countByRatingWebsite) {
            if (Object.hasOwnProperty.call($scope.countByRatingWebsite, key)) {
                const element = $scope.countByRatingWebsite[key];
                _count.total += element.count * element.rating;
                _count.count += element.count;
            }
        }

        const value = _count.total / _count.count;

        if (!isNaN(value)) {
            avgRatingCache.value = value.toFixed(1);
        } else if (!_count.count) {
            avgRatingCache.value = 0;
        }


        $scope.loadRatingCount = false;
        safeApply($scope);

    }

    const getProductRating = () => 
    {
        return new Promise((resolve, reject) => {
            $http.get(base_api_url + '/comment/rating-count?status=ACTIVE&targetId=' + $scope.productId).then(response => {                
                if (response.data.status === 'successful') {
                    return resolve(response.data.result);
                }
                resolve(null);
            }).catch(() => {
                resolve(null);
            });
        }) 
    }

    const getShopRating = () => 
    {
        let sellerId = null;
        const sellerIdElement = document.getElementById('userId');

        if (sellerIdElement && sellerIdElement.value) {
            sellerId = sellerIdElement.value;
        }

        let params = new URLSearchParams({
            productId: $scope.productId,
            pageSize: 1,
            pageId: 0,
            page: 1,
            seller_id: sellerId,
            get_rating: 1
        });

        let getCommentApiUrl = '/reviews/get-shop-comment?' + params.toString();
        if (localePrefix) getCommentApiUrl = '/' + localePrefix + getCommentApiUrl;

        return new Promise((resolve, reject) => {
            $http.get(getCommentApiUrl).then(response => {                
                if (response.data.status === 'successful' && response.data.ratingCount) {
                    return resolve(response.data.ratingCount.items);
                }
                resolve(null);
            }).catch(() => {
                resolve(null);
            });
        })
    }

    init();

    /* const userActionObserver = new IntersectionObserver(function (entries, observer) {
        entries.forEach(function (entry) {
            if (entry.isIntersecting) {
                init();
                userActionObserver.unobserve(entry.target);
            }
        });
    }, {
        root: null,
        rootMargin: '0px',
        threshold: 0.1
    });

    if (document.getElementById('reviews')) {
        userActionObserver.observe(document.getElementById('reviews'));
    } */

});

productPageModule.requires.push('ngSanitize');

productPageModule.controller('ListReviewController', function($scope, $http, DataService, $timeout) {

    $scope.websiteComments = [];
    $scope.websiteCommentPageId = 0;
    $scope.productId = $('#productId').val();
    $scope.isAdmin = false;
    $scope.highlightedId = '';

    $scope.existId = false;
    $scope.idHighlight = null;

    $scope.replyReview = {
        full_name: '',
        email: '',
        content: ''
    }

    $scope.pagination = {
        pageSize: 3,
        pageId: 0,
        pageCount: 0,
        totalCount: 0,
        pages: []
    }

    $scope.target = TARGETS.thisItem;

    function init() 
    {
        if (!isNaN($scope.productId)) {
            $scope.isAdmin = isAdmin;
            $scope.loading = false;
            $scope.getWebsiteComment(true);
            $scope.refreshComment();
            $scope.saveComment = () => DataService.get('saveComment')(data);

            DataService.change('changeTarget', changeTarget);
        } else {
            console.warn('cannot init product comment!');
        }
    }

    function changeProduct(productId) {
        $scope.productId = productId;
        init();
    }

    function changeTarget() {
        let dataServiceTarget = () => DataService.get('target');
        $scope.target = dataServiceTarget();
        $scope.getWebsiteComment(true);
    }

    $scope.changePosition = function(comment, action) {
        if (action === 'pin' && parseInt(comment.is_pin) === 1) {
            action = 'unpin';
        }

        let storeUrl = '/reviews/change-position?id=' + comment.id + '&action=' + action;
        if (localePrefix) storeUrl = '/' + localePrefix + storeUrl;

        $http({
            method: 'get',
            url: storeUrl,
        }).then(function success(response) {
            if (response.data.status === 'successful') {
                $scope.getWebsiteComment(true);
            }
        });
    }

    $scope.$watch(() => DataService.get('needRefesh'), function(newVal) {
        if (newVal) $scope.getWebsiteComment(true);
    }, true);

    $scope.getImageUrls = function(comment) {
        if (comment.images) {
            return JSON.parse(comment.images);
        }
    }

    $scope.checkSeeMore = function(comment) {
        return $('#reviewContent-' + comment.id).prop('scrollHeight') > 24;
    }

    $scope.zoomImage = function(comment, image, key) {

        let zoomImageElement = document.getElementById('module-review-img-' + comment.id + '_' + key);
        let zoomImageAreaElement = document.getElementById('module-review-img-zoom-' + comment.id);

        zoomImageAreaElement.parentNode.style.display = 'block';
        
        if (zoomImageAreaElement.src != image) {
            
            zoomImageAreaElement.src = '/modules/reviews/images/loading-1.gif';
            
            for (let index = 0; index < $scope.websiteComments.length; index++) {
                $scope.websiteComments[index].zoomImage = null;
            }

            let downloadingImage = new Image();
            downloadingImage.onload = function() 
            {
                zoomImageAreaElement.src = this.src;
            };
            downloadingImage.src = image;

            let imgElements = document.getElementsByClassName('module-review-img');
            for (let index = 0; index < imgElements.length; index++) {
                imgElements[index].classList.remove('focus');
            }

            zoomImageElement.classList.add('focus');

        } else {
            zoomImageAreaElement.parentNode.style.display = 'none';
            zoomImageAreaElement.src = '/modules/reviews/images/loading-1.gif';
            zoomImageElement.classList.remove('focus');
        }
    }

    function validateReply(_form) {
        resetReplyForm();

        let err = false;
        $scope.replyReview.errors = [];
        if (typeof $scope.replyReview.full_name == 'undefined' ||
            $scope.replyReview.full_name == '' ||
            $scope.replyReview.full_name == null) {
            err = true;
            pushReplyErrorMessage(_form, 'review-reply-fullname');
        }

        if (typeof $scope.replyReview.email == 'undefined' ||
            $scope.replyReview.email == '' ||
            $scope.replyReview.email == null) {
            err = true;
            pushReplyErrorMessage(_form, 'review-reply-email');

        } else if (!isValidEmail($scope.replyReview.email)) {
            err = true;
            pushReplyErrorMessage(_form, 'review-reply-email');
        }

        if (typeof $scope.replyReview.content == 'undefined' ||
            $scope.replyReview.content == '' ||
            $scope.replyReview.content == null) {
            err = true;
            pushReplyErrorMessage(_form, 'review-reply-content');
        }

        return err;
    }

    function pushReplyErrorMessage(_form, _class) {
        if (_form.getElementsByClassName(_class).length) {
            _form.getElementsByClassName(_class)[0].classList.add('error');
            let message = _form.getElementsByClassName(_class)[0].dataset.errorMessage;
            $scope.replyReview.errors.push(message);
        }
    }

    function resetReplyForm() {
        let inputs = document.getElementsByClassName('review-reply');
        for (let index = 0; index < inputs.length; index++) {
            inputs[index].classList.remove('error');
        }
    }

    $scope.validateReply = function($event) {
        let _form = $event.currentTarget.parentElement;
        return validateReply(_form);
    }

    $scope.postSubReview = function($event, comment) {
        let validated = !$scope.validateReply($event);
        if (validated) {
            let replyData = {
                full_name: $scope.replyReview.full_name,
                email: $scope.replyReview.email,
                content: $scope.replyReview.content,
                status: 'PENDING',
                target_id: $scope.productId,
                parent_id: comment.id
            }

            $scope.saveComment(replyData);

            $scope.replyReview = {
                rating: 5,
                target_id: $scope.productId
            };
        }
    }

    $scope.loadMoreComment = function() {
        $scope.websiteCommentPageId = $scope.websiteCommentPageId + 1;
        $scope.getWebsiteComment();
    }

    $scope.showReplyForm = function(comment, $event) {
        // reset show
        for (let index = 0; index < $scope.websiteComments.length; index++) {
            $scope.websiteComments[index].show_reply = null;
        }
        // reset input
        resetReplyForm();
        // reset message
        $scope.replyReview.errors = [];

        comment.show_reply = !comment.show_reply;
        setTimeout(() => {
            let fInput = $event.currentTarget.parentElement.getElementsByTagName('textarea');
            if (fInput && fInput.length) {
                fInput[0].focus();
            }
        });
    }

    $scope.getImageCdn = function($url, $width = 0, $height = 0, $fitIn = true, $webp = true) {

        $originUrl = $url;

        if (!$url) return "";
        if (typeof cdnIgnoreUrl !== 'undefined') {
            for (let item of cdnIgnoreUrl) {
                if ($url.includes(item)) {
                    return $url;
                }
            }
        }
        if (typeof cdnAllowUrl  !== 'undefined') {
            let check = false;
            for (let item of cdnAllowUrl ) {
                if ($url.includes(item)) {
                    check = true;
                    break;
                }
            }
            if (!check) {
                return $url;
            }
        }

        if ($url.substr(0, 4) == 'http') {
            $url = $url.replace('https://', '');
            $url = $url.replace('http://', '');
        } else {
            $url = document.domain + $url;
        }

        if ($url.includes('?')) {
            $url = encodeURIComponent($url);
        }

        if ($webp) {
            if (webpSupport) {
                $webp = true;
            } else {
                $webp = false;
            }
        }

        $webp = false;
        $baseCdnUrl = baseCdnUrl + "/";
        $fitIn = ($fitIn && $width && $height);
        $fitIn = false;
        if ($fitIn) {
            $baseCdnUrl += "fit-in/";
        }
        if ($width || $height) {
            $baseCdnUrl += $width + "x" + $height + "/";
        }
        if ($fitIn || $webp) {
            $baseCdnUrl += "filters";
        }
        if ($fitIn) {
            $baseCdnUrl += ":fill(fff)";
        }
        if ($webp) {
            $baseCdnUrl += ":format(webp)";
        }
        if ($fitIn || $webp) {
            $baseCdnUrl += "/";
        }
        $baseCdnUrl += $url;
        return $baseCdnUrl;
    }

    $scope.getWebsiteComment = async (reset = false, changePage = false) => {
        if (reset) {
            $scope.websiteCommentPageId = 0;
            $scope.pagination = {
                pageSize: 3,
                pageId: 0,
                pageCount: 0,
                totalCount: 0,
                pages: []
            }
        }
        var url = new URL(window.location.href);
        var id = url.hash !== "" ? url.hash.replace('#', '') : '';
        if (id && (!changePage|| $scope.pagination.pageId == 0)) {
            $scope.existId = true;
        } else {
            $scope.existId = false;
        }

        // $scope.getWebsiteCommentItem(reset, changePage);

        if ($scope.target === TARGETS.thisItem) {
            if ($scope.existId) {
                await $scope.loadFirstReview(id);
            }

            $scope.getWebsiteCommentItem(reset, changePage);
        } else if ($scope.target === TARGETS.thisShop) {

            $scope.getWebsiteCommentShop();

        }

        $timeout(function () {
            if ($scope.existId) {
                id = id.replace('/', '');
                $scope.highlightedId = id;
                var element = document.getElementById(id);
                if (element) {
                    element.scrollIntoView({behavior: 'smooth'});
                    element.classList.add('hightlight');
                }
            }
        }, 2000);

    }

    $scope.isHighlighted = function (id) {
        return $scope.highlightedId === id;
    };

    $scope.loadFirstReview = async (stringId) => {
        let firstWebsiteComments = [];
        let array = stringId.split('-');
        $scope.idHighlight = array[1];
        if ($scope.idHighlight) {
            const getFirtCommentApiUrl = base_api_url + '/comment/' + $scope.idHighlight;
            return $http.get(getFirtCommentApiUrl).then(response => {
                if (response.data.status === 'successful') {
                    response.data.result.isOnly = true;
                    firstWebsiteComments.push(response.data.result);
                    $scope.websiteComments = firstWebsiteComments;

                    setTimeout(() => {
                        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
                            $scope.$apply();
                        }
                    }, 200);
                }
            });
        }

    }

    $scope.getWebsiteCommentItem = function (reset = false, changePage = false) {
        $scope.loading = true;

        let params = new URLSearchParams({
            // withChildren: 1,
            withImages: 1,
            isParent: 1,
            status: 'ACTIVE',
            'order[is_pin]': 'desc',
            'order[sort_id]': 'desc',
            'order[created_at]': 'desc',
            targetId: $scope.productId, // $scope.productId
            pageSize: $scope.existId ? $scope.pagination.pageSize - 1 : $scope.pagination.pageSize,
            pageId: $scope.websiteCommentPageId
        });

        let getCommentApiUrl = base_api_url + '/comment?' + params.toString();

        if ($scope.idHighlight) {
            getCommentApiUrl += '&id_except=' + $scope.idHighlight;
        }

        $http.get(getCommentApiUrl).then(response => {
            if (response.data.status === 'successful') {

                for (const i of response.data.result) {
                    i.isOnly = false;
                }

                if (!reset && !changePage) {
                    $scope.websiteComments = $scope.websiteComments.concat(response.data.result);
                } else {
                    $scope.websiteComments = !$scope.existId ? response.data.result : $scope.websiteComments.concat(response.data.result);
                }

                $scope.websiteMeta = response.data.meta;

                DataService.change('websiteComments', $scope.websiteComments);
                DataService.change('websiteMeta', $scope.websiteMeta);

                $scope.pagination.pageCount = $scope.websiteMeta.page_count;
                $scope.pagination.totalCount = $scope.websiteMeta.total_count;

                $scope.buildPagination();

                setTimeout(() => {
                    $scope.loading = false;
                    if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
                        $scope.$apply();
                    }
                }, 200);
                
            }
        });
    }

    $scope.getWebsiteCommentShop = function() 
    {
        $scope.loading = true;

        let sellerId = null;
        const sellerIdElement = document.getElementById('userId');

        if (sellerIdElement && sellerIdElement.value) {
            sellerId = sellerIdElement.value;
        }

        let params = new URLSearchParams({
            productId: $scope.productId,
            pageSize: $scope.pagination.pageSize,
            pageId: $scope.websiteCommentPageId,
            page: $scope.websiteCommentPageId + 1,
            seller_id: sellerId,
            get_rating: 1
        });

        let getCommentApiUrl = '/reviews/get-shop-comment?' + params.toString();
        if (localePrefix) getCommentApiUrl = '/' + localePrefix + getCommentApiUrl;

        $http.get(getCommentApiUrl).then(response => {
            if (response.data.status === 'successful') {
                
                $scope.websiteComments = response.data.result;
                $scope.websiteMeta = response.data.meta;

                DataService.change('websiteComments', $scope.websiteComments);
                DataService.change('websiteMeta', $scope.websiteMeta);
                
                $scope.pagination.pageCount = $scope.websiteMeta.page_count;
                $scope.pagination.totalCount = $scope.websiteMeta.total_count;

                if (response.data.ratingCount) {
                    const ratingData = updateRatingData(response.data.ratingCount);
                    if (ratingData) {
                        $scope.overAll.shop = ratingData;
                        $scope.countByRatingWebsite = response.data.ratingCount;
                    }
                }

                $scope.buildPagination();

                $scope.loading = false;

                if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
                    $scope.$apply();
                }
                
            }
        });
    }

    const updateRatingData = (ratingCount) => {
        let sumRating = 0;
        let totalCount = 0;
        try {

            for (let index = 0; index < ratingCount.items.length; index++) 
            {
                let rating = parseInt(ratingCount.items[index].rating);
                let count = parseInt(ratingCount.items[index].count);

                sumRating   += rating * count;
                totalCount  += count;
            }
        
            let avgRating = sumRating / totalCount;

            if(Number(avgRating) === avgRating && avgRating % 1 !== 0) {
                avgRating = avgRating.toFixed(1);
            }

            if (isNaN(avgRating)) {
                avgRating = 0;
            }

            return {
                totalCount,
                avgRating,
                data: ratingCount
            };

        } catch (error) {
            console.warn(error);
        }
    }

    $scope.buildPagination = function() {

        let pages = [1];

        if ($scope.pagination.pageId > 1 && $scope.pagination.pageCount > 3) {
            pages.push('...');
        }

        if ($scope.pagination.pageId != 0 && $scope.pagination.pageId != $scope.pagination.pageCount - 1 && $scope.pagination.pageCount > 2) {
            pages.push($scope.pagination.pageId + 1);
        } else if ($scope.pagination.pageCount > 2) {
            if ($scope.pagination.pageId == 0 && $scope.pagination.pageId < $scope.pagination.pageCount - 1) {
                pages.push(2);
            }
            if ($scope.pagination.pageId == $scope.pagination.pageCount - 1 && $scope.pagination.pageId > 1) {
                pages.push($scope.pagination.pageId);
            }
        }

        if ($scope.pagination.pageId < $scope.pagination.pageCount - 2 && $scope.pagination.pageCount > 3) pages.push('...');

        pages.push($scope.pagination.pageCount);

        $scope.pagination.pages = pages;

    }

    $scope.changePage = function (newPageId) {
        $scope.pagination.pageId = newPageId;
        $scope.websiteCommentPageId = newPageId;

        $scope.getWebsiteComment(false, true);
        $scope.buildPagination();
    }

    $scope.refreshComment = function () {
        let refreshReview = '/reviews/refresh?id=' + $scope.productId;
        if (localePrefix) refreshReview = '/' + localePrefix + refreshReview;
        $http.get(refreshReview).then(response => {
        }).catch(err => console.warn(err));
    }

    $scope.formatTime = function (t, isOnly) {
        var t = t.split(/[- :]/);
        var d = new Date(Date.UTC(t[0], t[1] - 1, t[2], t[3], t[4], t[5]));
        if (isOnly) {
            d.setUTCHours(d.getUTCHours() - 7);
        }
        return d.toDateString();
    }

    $scope.addlbr = function (content) {
        if (!content) content = '';
        return content.replace(/\n/g, "<br />");
    }

    $scope.getFirstLetter = function (str) {
        return str.split(/\s/).reduce((response, word) => response += word.slice(0, 1), '');
    }

    init();

    /* const userActionObserver = new IntersectionObserver(function (entries, observer) {
        entries.forEach(function (entry) {
            if (entry.isIntersecting) {
                init();
                userActionObserver.unobserve(entry.target);
            }
        });
    });

    if (document.getElementById('ngReviewListController')) {
        userActionObserver.observe(document.getElementById('ngReviewListController'));
    } */

    window.addEventListener('chooseProductSku', e => {
        const sku = e.detail.sku();
        changeProduct(sku.product_id)
    });

});

productPageModule.controller('FormReviewController', function($scope, $http, DataService) {

    $scope.productId = $('#productId').val();
    $scope.review = {
        rating: '5',
        target_id: $scope.productId
    };
    $scope.replyReview = {
        rating: 5,
        target_id: $scope.productId
    };
    $scope.errors = {
        hasError: false,
        review: {
            title: false,
            full_name: false,
            email: false,
            content: false,
            images: false
        },
        reply: {
            full_name: false,
            email: false,
            content: false
        }
    }

    $scope.filesUpload = [];

    function init() {
        let formInputs = document.querySelectorAll('.module-review-text');
        if (formInputs && formInputs.length) {
            formInputs.forEach((fInput) => {
                fInput.addEventListener('focus', function(event) {
                    this.parentElement.classList.add('focus');
                    event.stopPropagation();
                })
                fInput.addEventListener('focusout', function(event) {
                    var inputValue = this.value;
                    if (!inputValue || inputValue == "")
                        this.parentElement.classList.remove('focus');
                })
            });
        }

        DataService.change('saveComment', saveComment);
    }

    $scope.isValidEmail = function(email) {
        var regex = /^[\w\.]+@[\w\.]+\.\w{2,5}$/;
        var retVal = email != null && email.match(regex) != null;
        return retVal;
    };

    $scope.postReview = function() {
        let validated = $scope.validated($scope.review, $scope.errors.review);
        $scope.errors.hasError = !validated;
        if (validated) {
            let reviewData = buildData();
            saveComment(reviewData);
        }
    }

    $scope.validated = function(scopeReview, scopeErrors) {
        let hasError = false;

        if (typeof scopeErrors.title != 'undefined') {
            if (typeof scopeReview.title == 'undefined' || scopeReview.title == '' || scopeReview
                    .title ==
                null) {
                scopeErrors.title = true;
                hasError = true;
            } else {
                scopeErrors.title = false;
            }
        }

        if (typeof scopeErrors.email != 'undefined') {
            if (typeof scopeReview.email == 'undefined' || scopeReview.email == '' || scopeReview
                    .email ==
                null) {
                scopeErrors.email = true;
                hasError = true;
            } else {
                if (!isValidEmail(scopeReview.email)) {
                    scopeErrors.email = true;
                    hasError = true;
                } else {
                    scopeErrors.email = false;
                }
            }
        }

        if (typeof scopeErrors.content != 'undefined') {
            if (typeof scopeReview.content == 'undefined' || scopeReview.content == '' || scopeReview
                .content == null) {
                scopeErrors.content = true;
                hasError = true;
            } else {
                scopeErrors.content = false;
            }
        }

        if (typeof scopeErrors.full_name != 'undefined') {
            if (typeof scopeReview.full_name == 'undefined' || scopeReview.full_name == '' ||
                scopeReview
                    .full_name == null) {
                scopeErrors.full_name = true;
                hasError = true;
            } else {
                scopeErrors.full_name = false;
            }
        }

        return !hasError;
    }

    function buildData() {
        var result = angular.copy($scope.review);
        if (typeof result.images != 'undefined') {
            result.images = JSON.stringify(result.images);
        }
        result.status = 'PENDING';
        return result;
    }

    function saveComment(data) {
        let storeUrl = '/reviews/store-comments';
        if (localePrefix) storeUrl = '/' + localePrefix + storeUrl;

        $scope.loading = true;
        $http({
            method: 'post',
            url: storeUrl,
            data: {
                comments: [data]
            }
        }).then(function success(response) {
            $scope.loading = false;
            if (response.data.status == 'successful') {

                $scope.replyReview = {
                    rating: 5,
                    target_id: $scope.productId
                };

                toastr.options = {
                    "positionClass": "toast-bottom-left",
                }
                toastr.success('Your content will be reviewed in 24 hours.');
                toastr.success('Thanks for your comment!');

                DataService.change('needRefesh', 1);

                $scope.cancelReview();

                if (!$scope.$$phase) {
                    $scope.$apply();
                }

            } else {
                toastr.error('Error. Please try again later!');
            }
        });
    }

    $scope.fileNameChanged = function() {
        var files = document.getElementById('selectImages').files;
        var countReviewImage = 0;
        if(typeof $scope.review != 'undefined' && $scope.review.images && $scope.review.images.length) {
            countReviewImage = $scope.review.images.length;
        }

        toastr.options = { "positionClass": "toast-bottom-left"};
        if (files.length) {
            let filesUpload = [];
            for (let index = 0; index < files.length; index++) {
                let file = files[index];

                var filesize = ((file.size / 1024) / 1024).toFixed(4);
                let validExtention = false;
                if(['png', 'jpg', 'jpeg', 'gif'].includes(file.name.split('.').pop())) {
                    validExtention = true;
                }

                if (filesize <= 2 && validExtention) {
                    if(filesUpload.length + countReviewImage + 1 > 5) {
                        toastr.warning('To many images! (Up to 5 images)');
                        break;
                    }
                    filesUpload.push(file);

                    loadMime(file, function(_type) {
                        if(_type == "unknown") return toastr.warning('Error, some images invalid! (Please check filesize and file extention!)');
                    })

                } else {
                    return toastr.warning('Error, some images invalid! (Please check filesize and file extention!)');
                }
            }

            if (filesUpload.length) {
                uploadFile(filesUpload);
            } 
        }
    }

    function loadMime(file, callback) {

        //List of known mimes
        var mimes = [
            {
                mime: 'image/jpeg',
                pattern: [0xFF, 0xD8, 0xFF],
                mask: [0xFF, 0xFF, 0xFF],
            },
            {
                mime: 'image/png',
                pattern: [0x89, 0x50, 0x4E, 0x47],
                mask: [0xFF, 0xFF, 0xFF, 0xFF],
            }
            // you can expand this list @see https://mimesniff.spec.whatwg.org/#matching-an-image-type-pattern
        ];

        function check(bytes, mime) {
            for (var i = 0, l = mime.mask.length; i < l; ++i) {
                if ((bytes[i] & mime.mask[i]) - mime.pattern[i] !== 0) {
                    return false;
                }
            }
            return true;
        }

        var blob = file.slice(0, 4); //read the first 4 bytes of the file

        var reader = new FileReader();
        reader.onloadend = function(e) {
            if (e.target.readyState === FileReader.DONE) {
                var bytes = new Uint8Array(e.target.result);

                for (var i=0, l = mimes.length; i<l; ++i) {
                    if (check(bytes, mimes[i])) return callback(mimes[i].mime);
                }

                return callback("unknown");
            }
        };
        reader.readAsArrayBuffer(blob);
    }

    function uploadFile(files) {
        $scope.loading = true;
        if (!$scope.$$phase) {
            $scope.$apply();
        }

        var formData = new FormData();
        for (let index = 0; index < files.length; index++) {
            formData.append("upload[]", files[index]);
        }

        var request = new XMLHttpRequest();
        request.open("POST", googleCloudStorageBucket + "/upload");
        request.onload = function(e) {
            var res = JSON.parse(this.responseText);
            if (typeof res.upload != 'undefined') {

                if(typeof $scope.review.images == 'undefined')
                    $scope.review.images = [];

                $scope.review.images = $scope.review.images.concat(res.upload);

                $scope.loading = false;
                if (!$scope.$$phase) {
                    $scope.$apply();
                }
            }
        };
        request.send(formData);
    }

    $scope.cancelReview = function() {
        // $('.module-review-form-wrapper').slideUp();
        $('.module-review-form-wrapper').removeClass('form-show');
        $scope.review = {
            rating: '5',
            target_id: $scope.productId
        };
        $scope.errors = {
            hasError: false,
            review: {
                title: false,
                full_name: false,
                email: false,
                content: false,
                images: false,
                status: 'PENDING'
            }
        }
    }

    $scope.removeImage = function(idx) {
        $scope.review.images.splice(idx, 1);
    }

    init();

});