
<div id="ngFormReviewController" class="module-form-wrapper" ng-controller="FormReviewController"  ng-cloak>
    <input type="checkbox" name="" id="openForm">
    <form id="moduleReviewForm" class="module-review-form-wrapper">
        <div class="module-rate-content">
            <label class="overall-heading" for="">{{ __('Overall Rating') }}</label>
            <div class="module-rate-box">
                <label class="module-rate-label" for="rating1" style="z-index: 5;">
                    <input id="rating1" ng-model="review.rating" type="radio" value="1" name="rate">
                    <span class="review-star-item"></span>
                </label>
                <label class="module-rate-label" for="rating2" style="z-index: 4;">
                    <input id="rating2" ng-model="review.rating" type="radio" value="2" name="rate">
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                </label>
                <label class="module-rate-label" for="rating3" style="z-index: 3;">
                    <input id="rating3" ng-model="review.rating" type="radio" value="3" name="rate">
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                </label>
                <label class="module-rate-label" for="rating4" style="z-index: 2;">
                    <input id="rating4" ng-model="review.rating" type="radio" value="4" name="rate">
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                </label>
                <label class="module-rate-label" for="rating5" style="z-index: 1;">
                    <input id="rating5" ng-model="review.rating"  type="radio" value="5" name="rate" checked>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                    <span class="review-star-item"></span>
                </label>
            </div>
        </div>
        <div class="module-rate-form-wrapp">
            <label class="module-review-label">{{ __('Write a customer review') }}</label>
            <div class="module-review-form-group" ng-class="{'error': errors.review.full_name}">
                <label class="module-review-form-label">{{ __('Enter Your Name') }}<i>*</i></label>
                <input ng-model="review.full_name" ng-change="errors.hasError && validated(review, errors.review)"
                    class="module-review-text" autocomplete="off" type="text" name="name" placeholder="Your name" value="">
                <small class="module-review-error-mess">{{ __('Please enter your name') }}</small>
            </div>
            <div class="module-review-form-group" ng-class="{'error': errors.review.email}">
                <label class="module-review-form-label">{{ __('Enter Your Email') }}<i>*</i></label>
                <input ng-model="review.email" ng-change="errors.hasError && validated(review, errors.review)"
                    class="module-review-text" autocomplete="off" type="email" name="email" placeholder="john@example.com" value="">
                <small class="module-review-error-mess">{{ __('Please enter your email') }}</small>
            </div>
            <div class="module-review-form-group" ng-class="{'error': errors.review.title}">
                <label class="module-review-form-label">{{ __('Title') }} <i>*</i></label>
                <input ng-model="review.title" ng-change="errors.hasError && validated(review, errors.review)"
                    class="module-review-text" autocomplete="off" type="text" name="title" placeholder="Title" value="">
                <small class="module-review-error-mess">{{ __('Please enter your title') }}</small>
            </div>
            <div class="module-review-form-group" ng-class="{'error': errors.review.content}">
                <label class="module-review-form-label">{{ __('Content') }} <i>*</i></label>
                <textarea ng-model="review.content" ng-change="errors.hasError && validated(review, errors.review)"
                    class="module-review-text" autocomplete="off" row="8" placeholder="Your comment"></textarea>
                <small class="module-review-error-mess">{{ __('Please enter your content') }}</small>
            </div>
            <div class="select-images-note">{{ __('Add photo (max. 5)')}}</div>
            <div class="module-action-image">
                <label class="module-review-file-selector" for="selectImages">
                    <div class="button dark" id="selectImagesButton">
                        <img src="{{ asset('modules/reviews/images/add-image.png')}}" alt="">
                    </div>
                    
                    <input
                        onchange="angular.element(this).scope().fileNameChanged()"
                        onclick="this.value = null;"
                        accept="image/*"
                        id="selectImages" multiple=""
                        style="display: none" type="file">
                </label>
                <div class="image-contrainer">
                    <span class="sb_image" ng-repeat="img in review.images track by $index">
                        <img class="comment-image" height="58px" ng-src="@{{ img }}">
                        <button type="button" name="button" class="button image-remove" ng-click="removeImage($index);" title="Xóa ảnh này">&times;</button>
                    </span>
                </div>
            </div>
            <div class="module-review-action-wrapper">
                <button ng-disabled="loading" ng-click="postReview()" type="button" class="button primary module-review-action-write" id="module-write-review">
                    <span ng-if="!(loading == true)"> {{ __('Submit') }}</span>
                    <span ng-if="loading == true"> {{ __('Processing...') }}</span>
                </button>
                <button ng-click="cancelReview()" type="button" class="button secondary module-review-action-cancel" id="module-cancel-review">
                    {{ __('Cancel') }}
                </button>
            </div>
        </div>
    </form>
</div>
