@extends('system.layout.main', [
'ngController' => 'ReviewLibManagerController'
])
@section('title')
    <title>Reviews, Comments Library</title>
@endsection
@section('content')
    @include('reviews::includes.style')
    <div class="content" ng-cloak>
        <div class="body">
            <div class="box no-border">
                <div class="box-header">
                    <div class="pull-left">
                        <h3 class="">Reviews, Comments Library</h3>
                    </div>
                    <button type="button" name="button" class="btn btn-success btn-flat pull-right add" 
                        style="margin-top: 15px; border-radius: 5px" 
                        id="btnSaveMap" ng-click="openForm(); mode = 'create'; status.is_changing_target = true;">
                        <i class="fa fa-plus"></i>  <span style="margin-left: 5px">New review</span>
                    </button>
                    <button type="button" name="button" class="btn btn-default btn-flat pull-right add" style="margin-top: 15px; border-radius: 5px; margin-right: 5px" id="btnSaveMap"
                            ng-click="openFormImport(); mode = 'create'; status.is_changing_target = true;">
                        <i class="fa fa-cloud-upload" aria-hidden="true"></i>  <span style="margin-left: 5px">Import reviews</span>
                    </button>
                    {{--<button ng-click="openFormSetting();"
                            class="btn btn-default btn-flat pull-right" style="margin-top: 15px; margin-right: 7px; border-radius: 5px">
                        <i class="fa fa-gear"></i> Setting
                    </button>--}}
                    <div class="clearfix">
                    </div>
                    <a href="/reviews/manager" style="margin-top: 15px; margin-right: 7px; border-radius: 5px">
                        <i class="fa fa-arrow-left"></i> Back to review list
                    </a>
                </div>
                <div class="box-body">

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="text" ng-keyup="$event.keyCode == 13 && fetchComments()" ng-model="filters.search" class="form-control" placeholder="Search Keyword">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <button type="button" class="btn btn-primary " ng-click="fetchComments()">
                                <i class="fa fa-search"></i>
                                Search
                            </button>
                            <button type="button" class="btn btn-default ml-3" ng-click="removeAllFilters()">
                                <i class="fa fa-refresh"></i>
                                Reset
                            </button>
                        </div>  
                    </div>

                    <div ng-if="status.is_fetching_comments" style="position: absolute; width: 100%;">
                        <div class="loader">Loading...</div>
                    </div>
                    
                    <table class="table table-bordered" style="margin-top: 25px;">
                        <tr>
                            {{-- <th>
                                <input type="checkbox" id="js-product-checkall" ng-click="selectAllAdvertising()">
                            </th> --}}
                            <th>#</th>
                            <th style="width: 20%">Author / Title</th>
                            <th>Email</th>
                            <th>Content</th>
                            <th class="text-center">Score</th>
                            <th>Category</th>
                        </tr>
                        <tr ng-repeat="comment in comments" class="row-comment comment-@{{ comment.status.toLowerCase() }}">
                            {{-- <td>
                                <input type="checkbox" id="js-check" ng-click="">
                            </td> --}}
                            <td>#@{{ comment.id }}</td>
                            <td>
                                <span ng-if="comment.title"> <strong>@{{ comment.title }}</strong> <br></span>
                                @{{ comment.fullname }}
                                
                            </td>
                            <td>
                                <a href="mailto:@{{ comment.email }}">@{{ comment.email }}</a>
                            </td>
                            <td class="row-content">
                                <span ng-bind-html="addlbr(comment.content)"></span>
                                <div class="row-actions">
                                    <button ng-click="openForm(comment)" class="btn btn-xs btn-success">Edit</button>
                                    <button ng-click="deleteComment(comment)" class="btn btn-xs btn-danger">Delete</button>
                                </div>
                            </td>
                            <td class="text-center">@{{ comment.rating }}</td>
                            <td>@{{ comment.category.name }}</td>
                        </tr>

                    </table>

                </div>
                <div class="box-footer clearfix" ng-if="!status.is_fetching_comments && pagination.number_page > 1">
                    <ul class="pagination pull-right">
                        <li ng-repeat="n in range(pagination.current_page - 4, pagination.current_page - 1)"
                            ng-if="n > 0" class="page-item">
                            <a ng-click="pagination.current_page = n; fetch();" class="page-link"
                                href="#">@{{ n }}</a>
                        </li>
                        <li class="page-item active">
                            <a href="#">@{{ pagination.current_page }}</a>
                        </li>
                        <li ng-repeat="n in range(pagination.current_page + 1, pagination.current_page + 4)"
                            ng-if="n <= pagination.number_page" class="page-item">
                            <a ng-click="pagination.current_page = n; fetch();" class="page-link"
                                href="#">@{{ n }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    @include('reviews::includes.form-popup-lib')
    @include('reviews::includes.import-popup')
    {{--@include('reviews::includes.seeding-setting-popup')--}}

@endsection
@section('script')
    <script>
        var base_url = '<?= url(' / ') ?>';

    </script>
    <script src="@asset('reviews/controllers/reviews-lib-controller.js')"></script>
@endsection
