@extends('system.layout.main', [
'ngController' => 'ReviewManagerController'
])
@section('title')
    <title>Reviews, Comments Manager</title>
@endsection
@section('css')
    <style>
        .bulk-actions {
            z-index: 19;
            position: absolute;
            background: #fefefe;
            white-space: nowrap;
            font-weight: 400;
            top: -17px;
        }
    </style>
<link rel="stylesheet" href="@asset('reviews/css/lightbox.min.css')" media="screen">
<link rel="stylesheet" href="@asset('reviews/css/jquery.datetimepicker.css')" media="screen">
@endsection
@section('content')
    @include('reviews::includes.style')
    <div class="content" ng-cloak>
        <div class="body">
            <div class="box no-border">
                <div class="box-header">
                    <div class="pull-left">
                        <h3 class="">Reviews, Comments Manager</h3>
                    </div>
                    <button type="button" name="button" class="btn btn-success btn-flat pull-right add" 
                        style="margin-top: 15px; border-radius: 5px" 
                        id="btnSaveMap" ng-click="openForm(); mode = 'create'; status.is_changing_target = true;">
                        <i class="fa fa-plus"></i>  <span style="margin-left: 5px">New review</span>
                    </button>
<!--                    <button type="button" name="button" class="btn btn-default btn-flat pull-right add"
                        style="margin-top: 15px; border-radius: 5px; margin-right: 5px" 
                        id="btnSaveMap" ng-click="openFormImport(); mode = 'create'; status.is_changing_target = true;">
                        <i class="fa fa-cloud-upload" aria-hidden="true"></i>  <span style="margin-left: 5px">Import reviews</span>
                    </button>-->
                    <a href="/reviews/library" type="button" name="button" class="btn btn-default btn-flat pull-right add" 
                        style="margin-top: 15px; border-radius: 5px; margin-right: 5px;" >
                        <span style="margin-left: 5px">Go to Library</span>
                    </a>
                    <div class="clearfix">
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <input type="text" ng-keyup="$event.keyCode == 13 && fetchComments()" ng-model="filters.search" class="form-control" placeholder="Search Keyword">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control" ng-model="filters.has_image">
                                    <option value="">-- Images --</option>
                                    <option value="EXISTS">Exists images</option>
                                    <option value="NOT_EXISTS">Not exists images</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control" ng-model="filters.status">
                                    <option value="">-- Choose review Status --</option>
                                    <option value="ACTIVE">ACTIVE</option>
                                    <option value="PENDING">PENDING</option>
                                    <option value="BLOCK">BLOCK</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control" ng-model="filters.target_type">
                                    <option value="">-- Choose Target Type --</option>
                                    <option value="PRODUCT">PRODUCT</option>
                                    <option value="POST">POST</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control" ng-model="filters.rating">
                                    <option value="">-- Choose Score --</option>
                                    <option value="5">5</option>
                                    <option value="4">4</option>
                                    <option value="3">3</option>
                                    <option value="2">2</option>
                                    <option value="1">1</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <input
                                    type="text"
                                    class="form-control"
                                    ng-model="filters.created_from"
                                    my-date-picker
                                    placeholder="Created From"
                                >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <input
                                    type="text"
                                    class="form-control"
                                    ng-model="filters.created_to"
                                    my-date-picker
                                    placeholder="Created To"
                                >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <select class="form-control" ng-model="filters.is_real">
                                    <option value="">-- Choose Comment Type --</option>
                                    <option value="0">Fake</option>
                                    <option value="1">Real</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <button type="button" class="btn btn-primary " ng-click="fetchComments()">
                                <i class="fa fa-search"></i>
                                Search
                            </button>
                            <button type="button" class="btn btn-default ml-3" ng-click="removeAllFilters()">
                                <i class="fa fa-refresh"></i>
                                Reset
                            </button>
                        </div>
                    </div>
                    <div ng-if="status.is_fetching_comments" style="position: absolute; width: 100%;">
                        <div class="loader">Loading...</div>
                    </div>

                    <div class="table-responsive table-filter" style="min-height: 500px">
                        <div style="position: relative">
                            <div class="bulk-actions" ng-show="selectedCommentIds.length > 0">
                                <div class="bulk-actions-inner">
                                    <ul class="bulk-actions-inner-bar">
                                        <li class="segments" style="background: #dfe3e8;font-weight: bold;padding: 10px 5px;">
                                            <input id="js-reset-check-all" type="checkbox" ng-click="resetOrCheckAll()">
                                            <span>@{{ selectedCommentIds.length }} đánh giá được chọn</span>
                                        </li>
                                        <li class="segments dropdown" style="cursor: pointer; display: inline-block; width: auto">
                                            <span class="dropdown-toggle" data-toggle="dropdown">
                                                Chọn hành động <span class="caret"></span>
                                            </span>
                                            <ul class="dropdown-menu" style="left: -4px;clear: both;padding: 0;margin-top: 6px;">
                                                <li class="actions" ng-click="changeBulkStatusComment('ACTIVE')">
                                                    <i class="fa fa-check" aria-hidden="true"></i> Approve
                                                </li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <table class="table table-bordered" style="margin-top: 25px;">
                            <tr ng-show="!selectedCommentIds.length">
                                <th style="width: 10px">
                                    <input type="checkbox" id="js-comment-check-all" ng-click="selectAllComments()">
                                </th>
                                <th>#</th>
                                <th style="width: 20%">Author / Title</th>
                                <th>Content</th>
                                <th>Images (click to expands)</th>
                                <th class="text-center">Score</th>
                                <th style="width: 150px;">Target</th>
                                <th style="width: 14%">Created at</th>
                            </tr>
                            <tr ng-repeat="comment in comments" class="comment-item list-order-body row-comment comment-@{{ comment.status.toLowerCase() }}">
                                <td>
                                    <input type="checkbox" class="js-comment-checkbox" ng-click="addSelectedComments(comment.id); $event.stopPropagation();">
                                </td>
                                <td>#@{{ comment.id }}</td>
                                <td>
                                    <span ng-if="comment.title">@{{ comment.title }} <br></span>
                                    @{{ comment.full_name }} -
                                    <a href="mailto:@{{ comment.email }}">@{{ comment.email }}</a>
                                </td>
                                <td class="row-content">
                                    <span ng-bind-html="addlbr(comment.content)"></span>
                                    <div class="row-actions">
                                        <button ng-if="comment.status != 'ACTIVE'"
                                            ng-click="quickUpdate(comment, {key: 'status', value: 'ACTIVE'})"
                                            class="btn btn-xs btn-success">
                                            Show / Approve
                                        </button>
                                        <button ng-if="comment.status == 'ACTIVE'"
                                            ng-click="quickUpdate(comment, {key: 'status', value: 'BLOCK'})"
                                            class="btn btn-xs btn-warning">
                                            Hide / Block
                                        </button>
                                        <button ng-click="replyComment(comment)" ng-if="!comment.parent_id" class="btn btn-xs btn-info">Reply</button>
                                        <button ng-click="openForm(comment)" class="btn btn-xs btn-success">Edit</button>
                                        <button ng-click="deleteComment(comment)" class="btn btn-xs btn-danger">Delete</button>
                                    </div>
                                </td>
                                <td>
                                    <div ng-if="comment.images.length > 0">
                                        <div ng-repeat="image in comment.images">
                                            <a href="@{{ image }}" data-lightbox="image-1">
                                                <img src="@{{ image }}" alt="" style="width: 300px; height: auto;">
                                            </a>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">@{{ comment . rating }}</td>
                                <td>
                                    <img ng-if="status.is_fetching_targets" class="small-img-loading" src="@asset('reviews/images/loading-1.gif')">
                                    <span ng-if="!status.is_fetching_targets">
                                        @{{ comment.target_type }}
                                        <a target="_blank" class="limit-row-2" ng-if="comment.target" href="@{{ locale }}@{{ comment.target.url }}" title="@{{ comment.target.name }}">
                                            @{{ comment.target.name }}
                                        </a>
                                        <span ng-if="comment.parent_id">Reply to #@{{ comment.parent_id }}</span>
                                    </span>
                                </td>
                                <td>@{{ comment . created_at }}</td>
                            </tr>

                        </table>
                    </div>

                </div>
                <div class="box-footer clearfix" ng-if="!status.is_fetching_comments && pagination.number_page > 1">
                    <ul class="pagination pull-right">
                        <li ng-repeat="n in range(pagination.current_page - 4, pagination.current_page - 1)"
                            ng-if="n > 0" class="page-item">
                            <a ng-click="pagination.current_page = n; fetch();" class="page-link"
                                href="#">@{{ n }}</a>
                        </li>
                        <li class="page-item active">
                            <a href="#">@{{ pagination . current_page }}</a>
                        </li>
                        <li ng-repeat="n in range(pagination.current_page + 1, pagination.current_page + 4)"
                            ng-if="n <= pagination.number_page" class="page-item">
                            <a ng-click="pagination.current_page = n; fetch();" class="page-link"
                                href="#">@{{ n }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    @include('reviews::includes.form-popup')
    @include('reviews::includes.import-popup')

@endsection
@section('script')
    <script src="@asset('reviews/js/lightbox-plus-jquery.min.js')"></script>
    <script>
        var base_url = '<?= url(' / ') ?>';

    </script>
    <script src="@asset('reviews/controllers/reviews-controller.js')?v={{ config('sa.version') }}"></script>
    <script src="@asset('reviews/js/jquery.datetimepicker.js')"></script>
@endsection
