<div id="reviews" class="review-wrapper section-product-page ng-cloak">
    <div id="ngReviewController" ng-controller="ReviewController">
        <?php
            $showAvgRating = \Config::get('reviews::display.show_avg_rating');
        ?>

        <label for="openForm" class="write-review product-detail-heading section-product-page-title">
            {{ __('Reviews') }}
        </label>
        <div class="review-tabs ng-cloak">
            <label class="review-tab-item" ng-class="{'active': target == targets.thisItem, 'disable': loadRatingCount }" ng-click="!loadRatingCount && changeTarget(targets.thisItem)">
                <span class="hide-mobile">{{ __('Reviews for this item') }}</span>
                <span class="hide-desktop">{{ __('Item reviews') }}</span>
                {{-- <span ng-if="overAll.item.totalCount > 0" class="review-tab-item-count">
                    @{{ overAll.item.totalCount }}
                </span> --}}
            </label>
            <label class="review-tab-item" ng-class="{'active': target == targets.thisShop, 'disable': loadRatingCount }" ng-click="!loadRatingCount && changeTarget(targets.thisShop)">
                <span class="hide-mobile">{{ __('Reviews for this shop') }}</span>
                <span class="hide-desktop">{{ __('Shop reviews') }}</span>
                {{-- <span ng-if="overAll.shop.totalCount > 0" class="review-tab-item-count">
                    @{{ overAll.shop.totalCount }}
                </span> --}}
            </label>
        </div>
        <div ng-if="loadRatingCount">
            <div class="div-review-box-top" >
                <div class="product-review-box">
                    <div class="avg-rating">
                        <div style="line-height: 1.1; font-size: calc(35px + (41 - 35) * ((100vw - 300px) / (1920 - 300))); font-weight: 500; margin-bottom: 12px;">@{{ getAvgRaring() }}/5</div>
                    </div>
                    <div class="product-rating-percent">
                        <?php for ($i=0; $i < 5; $i++) : ?>
                            <div class="product-review-item animated-background" style="height: 24px; width: 100%; margin-bottom: 8px; border-radius: 7px"></div>
                        <?php endfor ?>
                    </div>
                </div>
                <div class="module-review-list-wrapper">
                    <div class="module-review-list">
                        @for ($i = 0; $i < 3; $i++)
                        <div class="module-review-item" style="<?= $i == 0 ? '' : 'border-top: 1px dashed #CCCCCC; padding-top: 16px;'?>">
                            <div class="module-review-star animated-background" style="width: 85px; height: 14px;;  border-radius: 7px"></div>
                            <div class="module-review-content-wrapper">
                                <div class="title animated-background" style="width: <?= mt_rand(120, 278) ?>px; height: 24px; margin-bottom: 5px; margin-top: 6px; border-radius: 7px"></div>
                                <div class="more-review-wrapper animated-background" style="width: 100%; height: 24px;  border-radius: 7px"></div>
                                <div class="module-review-item-top" style="display: flex; align-items: center; margin-bottom: 16px; margin-top: 10px;">
                                    <div class="module-review-avatar animated-background" style="width: 24px; height: 24px; border-radius: 24px"></div>
                                    <div class="full-name animated-background" style="width: <?= mt_rand(120, 278) ?>px; height: 24px; margin: 0 10px; border-radius: 5px"></div>
                                </div>
                            </div>
                        </div>
                        @endfor
                    </div>
                </div>  
            </div>
        </div>
        <div class="div-review-box-top">
            @include('reviews::embeds.review-overall', ['show_avg_rating' => $showAvgRating])
            @include('reviews::embeds.review-list')
            <div class="viewall-box flex-b align-c">
                <span class="viewall-rating write-review" ng-click="openForm();">
                    + {{ __('Write your review') }}
                </span>
            </div>
        </div>
        @include('reviews::embeds.review-form')
    </div>
</div>