<div class="modal fade" id="modalCommentForm" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" style="border-radius: 5px">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span ng-show="mode == 'create'">Add new comment</span>
                    <span ng-show="mode == 'update'">
                        Editing:  
                        @{{ currentComment.title }} - 
                        @{{ currentComment.fullname }}
                    </span>
                </h4>
            </div>
            <div class="modal-body" ng-keyup="$event.keyCode == 13 && save()">

                <fieldset class="scheduler-border" ng-if="currentComment.parent_id">
                    <legend class="scheduler-border">Reply to</legend>
                    <div class="form-group">
                        <strong>@{{ currentComment.parent.title }}</strong>
                        <p ng-bind-html="addlbr(currentComment.parent.content)"></p>
                        {{-- <button class="btn btn-sm btn-light" ng-click="moreLessContent()" id="moreLessBtn">More
                            / Less</button> --}}
                    </div>
                </fieldset>

                <fieldset class="scheduler-border">
                    <legend class="scheduler-border">Author Info</legend>
                    <div class="form-group">
                        <label for="">Name</label>
                        <input id="inputFullname" type="text" class="form-control" ng-model="currentComment.fullname">
                    </div>
                    <div class="form-group">
                        <label for="">Email</label>
                        <input type="email" class="form-control" ng-model="currentComment.email">
                    </div>
                </fieldset>

                <fieldset class="scheduler-border">
                    <legend class="scheduler-border">Review</legend>
                    <div class="form-group">
                        <label for="">Title</label>
                        <input type="text" class="form-control" ng-model="currentComment.title">
                    </div>
                    <div class="form-group">
                        <label for="">Content</label>
                        <textarea class="form-control" 
                            ng-keyup="$event.stopPropagation();"
                            ng-model="currentComment.content" cols="30" rows="10"></textarea>
                    </div>
                    <div class="form-group" style="display: inline-block" ng-if="!currentComment.parent_id">
                        <label for="">Score</label>
                        <input style="width: 55px" class="form-control" ng-model="currentComment.rating">
                    </div>
                    <div class="form-group">
                        <label for="">Category:</label>
                        <select class="form-control" ng-model="currentComment.category_id"
                            style="width: auto;">
                            <option ng-value="-1">All category</option>
                            <option ng-repeat="category in categories" ng-value="@{{ category.id }}">@{{ category.name }}</option>
                        </select>
                        <button class="btn" 
                            ng-click="status.is_changing_target = false;"
                            style="margin-bottom: 3px;" 
                            ng-if="currentComment.target">Cancel</button>
                    </div>
                    <div class="form-group" ng-if="!currentComment.parent_id">
                        <label for="">Images (Up to 5 images)</label> <p ng-if="uploading")>Please wait! Uploading . . .</p> <br>
                        <a ng-if="!uploading" ngf-select="uploadImages($files)" multiple="multiple" class="btn-upload-image">
                            <i class="fa fa-cloud-upload" aria-hidden="true"></i> Choose files
                        </a>
                    </div>
                    <div class="form-group">
                        <span class="sb_image" ng-repeat="img in currentComment.images track by $index">
                            <img class="comment-image" height="58px" src="@{{ img }}">
                            <div class="middle">
                                <button type="button" name="button" class="btn btn-default btm-xs" ng-click="removeImage($index);" title="Xóa ảnh này"><i class="fa fa-trash"></i></button>
                            </div>
                        </span>
                    </div>
                </fieldset>
             
            </div>
            <div class="modal-footer">
                <button id="btnUpdate" ng-show="mode == 'create'" ng-click="save()" type="button" class="btn btn-primary btn-save">
                    <i class="fa fa-plus"></i> Add
                </button>
                <button id="btnSaveComment" ng-show="mode == 'update'" ng-click="save()" type="button" class="btn btn-primary btn-save">
                    <i class="fa fa-save"></i> Save
                </button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
