<div class="modal fade" id="modalCommentForm" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" style="border-radius: 5px">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span ng-show="mode == 'create'">Add new comment</span>
                    <span ng-show="mode == 'update'">
                        Editing:  
                        @{{ currentComment . title }} - 
                        @{{ currentComment . full_name }}
                    </span>
                </h4>
            </div>
            <div class="modal-body" ng-keyup="$event.keyCode == 13 && save()">

                <fieldset class="scheduler-border" ng-if="currentComment.parent_id">
                    <legend class="scheduler-border">Reply to</legend>
                    <div class="form-group">
                        <strong>@{{ currentComment.parent.title }}</strong>
                        <p ng-bind-html="addlbr(currentComment.parent.content)"></p>
                        {{-- <button class="btn btn-sm btn-light" ng-click="moreLessContent()" id="moreLessBtn">More
                            / Less</button> --}}
                    </div>
                </fieldset>

                <fieldset class="scheduler-border" ng-if="!status.is_fetching_targets">
                    <legend class="scheduler-border">Target</legend>
                    <div class="form-group" ng-if="!status.is_changing_target">
                        @{{ currentComment.target_type }}:
                        <a target="_blank" ng-if="currentComment.target" href="@{{ currentComment.target.url }}" title="@{{ currentComment.target.name }}">
                            <strong>@{{ currentComment.target.name }}</strong>
                        </a> 
                        <a href="" ng-if="!currentComment.parent_id" style="margin-left: 8px; white-space: nowrap;" ng-click="status.is_changing_target = true">
                            | <i class="fa fa-pencil-square-o" aria-hidden="true"></i> Change
                        </a>
                    </div>
                    <div class="form-group" ng-if="status.is_changing_target">
                        <label for="">Target Type: </label>
                        <select class="form-control" ng-model="currentComment.target_type"
                            ng-change="changeKeywordTarget(true)"
                            style="width: auto; display: inline-block">
                            <option value="PRODUCT" selected>PRODUCT</option>
                            <option value="POST">POST</option>
                        </select>
                        <button class="btn" 
                            ng-click="status.is_changing_target = false;"
                            style="margin-bottom: 3px;" 
                            ng-if="currentComment.target">Cancel</button>
                    </div>
                    <div class="form-group" ng-if="status.is_changing_target">
                        <label for="">Target</label>
                        <input ng-model="state.search_string" 
                            ng-keyup="changeKeywordTarget()" 
                            ng-paste="changeKeywordTarget()"
                            type="text" class="form-control" placeholder="Search Target">

                        <div class="text-center mt-3" ng-if="status.is_searching">
                            <img class="small-img-loading" src="@asset('reviews/images/loading-1.gif')"> searching ...
                        </div>

                        <div ng-if="resultSearch.length" class="mt-3" style="position: relative;">
                            <div class="list-group" id="boxSearchResult">
                                <a ng-repeat="item in resultSearch" 
                                    style="cursor: pointer;"
                                    ng-click="changeTarget(item)"
                                    class="list-group-item list-group-item-action">
                                    @{{ item.name }}
                                </a>
                            </div>
                        </div>
                    </div>
                </fieldset>

                <fieldset class="scheduler-border">
                    <legend class="scheduler-border">Author Info</legend>
                    <div class="form-group">
                        <label for="">Name</label>
                        <input id="inputFullName" type="text" class="form-control" ng-model="currentComment.full_name">
                    </div>
                    <div class="form-group">
                        <label for="">Email</label>
                        <input type="email" class="form-control" ng-model="currentComment.email">
                    </div>
                </fieldset>

                <fieldset class="scheduler-border">
                    <legend class="scheduler-border">Review</legend>
                    <div class="form-group">
                        <label for="">Title</label>
                        <input type="text" class="form-control" ng-model="currentComment.title">
                    </div>
                    <div class="form-group">
                        <label for="">Content</label>
                        <textarea class="form-control" 
                            ng-keyup="$event.stopPropagation();"
                            ng-model="currentComment.content" cols="30" rows="10"></textarea>
                    </div>
                    <div class="form-group" style="display: inline-block" ng-if="!currentComment.parent_id">
                        <label for="">Score</label>
                        <input style="width: 55px" class="form-control" ng-model="currentComment.rating">
                    </div>
                    <div class="form-group">
                        <label for="">Created At</label>
                        <input
                            type="text"
                            class="form-control"
                            ng-model="currentComment.created_at"
                            placeholder="Created At"
                            id="createdComment"
                        >
                    </div>
                    <div class="form-group" style="display: inline-block">
                        <label for="">Verified</label>
                        <select class="form-control" ng-model="currentComment.is_verified" style="width: auto;">
                            <option value="1">Verified</option>
                            <option value="0">Not Verified</option>
                        </select>
                    </div>
                    <div class="form-group" style="display: inline-block">
                        <label for="">Type</label>
                        <select class="form-control" style="width: auto"
                            ng-options="status for status in commentStatuses"
                            ng-model="currentComment.status"
                            >
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="inputPinReview">
                            <input id="inputPinReview"
                                type="checkbox"
                                ng-model="currentComment.is_pin"
                                ng-true-value="'1'"
                            />
                            <span style="vertical-align: middle; display: inline-block; cursor: pointer">
                                Pin this review
                            </span>
                        </label>
                    </div>
                    <div class="form-group" ng-if="!currentComment.parent_id">
                        <label for="">Images (Up to 5 images)</label>
                        <p ng-if="uploading">Please wait! Uploading . . .</p> <br>
                        <a ng-if="!uploading" ngf-select="uploadImages($files)" multiple="multiple" class="btn-upload-image">
                            <i class="fa fa-cloud-upload" aria-hidden="true"></i> Choose files
                        </a>
                    </div>
                    <div class="form-group">
                        <span class="sb_image" ng-repeat="img in currentComment.images track by $index">
                            <img class="comment-image" height="58px" src="@{{ img }}">
                            <div class="middle">
                                <button type="button" name="button" class="btn btn-default btm-xs" ng-click="removeImage($index);" title="Xóa ảnh này"><i class="fa fa-trash"></i></button>
                            </div>
                        </span>
                    </div>
                </fieldset>
             
            </div>
            <div class="modal-footer">
                <button id="btnUpdate" ng-show="mode == 'create'" ng-click="save()" type="button" class="btn btn-primary btn-save">
                    <i class="fa fa-plus"></i> Add
                </button>
                <button id="btnSaveComment" ng-show="mode == 'update'" ng-click="save()" type="button" class="btn btn-primary btn-save">
                    <i class="fa fa-save"></i> Save
                </button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
