<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'reviews', 'middleware' => 'example'], function () {

    Route::get('/', [
        'as' => 'reviews::home',
        'uses' => 'HomeController@index',
    ])->middleware(config('app.system_auth_middleware'));

    Route::get('/manager', [
        'uses' => 'HomeController@manager',
    ])->middleware(config('app.system_auth_middleware'));

    Route::get('/library', [
        'uses' => 'HomeController@library',
    ])->middleware(config('app.system_auth_middleware'));

    Route::get('/seeding-setting', [
        'uses' => 'CommentLibController@loadSeedingSetting',
    ]);

    Route::post('/seeding-setting', [
        'uses' => 'CommentLibController@storeSeedingSetting',
    ]);

    Route::any('/import', [
        'uses' => 'CommentController@importProductCommentsV2',
    ]);
    
    Route::any('/import-lib', [
        'uses' => 'CommentController@importToLib',
    ]);

    Route::any('/fake', [
        'uses' => 'CommentController@fakeComments',
    ]);

    Route::any('/refresh', [
        'uses' => 'CommentController@fakeProductComments',
    ])->middleware(['bot.default_response']);

    Route::any('/re-calculate-rating', [
        'uses' => 'CommentController@reCalculateRating',
    ]);

    Route::any('/re-calculate-rating-by-ids', [
        'uses' => 'CommentController@reCalculateRatingByIds',
    ]);

    Route::any('/map-fullname', [
        'uses' => 'CommentController@mapFullname',
    ]);

    Route::post('store-comments', ['uses' => 'CommentController@storeComment']);
    Route::get('fetch-comment', ['uses' => 'CommentController@find']);
    Route::get('get-comment/{commentId}', ['uses' => 'CommentController@getComment']);
    Route::delete('delete-comment/{commentId}', ['uses' => 'CommentController@deleteComment'])->middleware(config('app.system_auth_middleware'));
    Route::get('load-target/{commentIds}', ['uses' => 'CommentController@LoadCommentTarget']);
    Route::get('update-count/{targetId}', ['uses' => 'CommentController@updateCountComment']);

    Route::post('store-comments-lib', ['uses' => 'CommentLibController@storeComment']);
    Route::get('fetch-comment-lib', ['uses' => 'CommentLibController@find']);
    Route::delete('delete-comment-lib/{commentId}', ['uses' => 'CommentLibController@deleteComment'])->middleware(config('app.system_auth_middleware'));

    Route::get('best-reviews', ['uses' => 'CommentController@loadBestReviews']);
    Route::get('build-verify', ['uses' => 'CommentController@buildVerifiedComment']);

    Route::get('pin', ['uses' => 'CommentController@pinComment']);
    Route::get('change-position', ['uses' => 'CommentController@changeCommentPosition']);

    Route::get('get-shop-comment', 'CommentController@getShopReviews');
    Route::get('get-shop-rating-count', 'CommentController@ratingShopCount');

    Route::get('mark-fake-comment', 'CommentLibController@markFakeComments');

});
