<?php

namespace Modules\Seller\Controllers\Frontend;

use DB;
use Illuminate\Http\Request;
use Modules\Seller\Models\User;
use Modules\Seller\Models\Order;
use Modules\Seller\Models\Product;
use Illuminate\Support\Facades\Hash;
use Modules\Seller\Models\OrderItem;
use Modules\Seller\Models\ProductSku;
use Modules\Seller\Controllers\Controller;
use Modules\Seller\Models\ProductSkuValue;
use Modules\Seller\Models\ProductNCategory;

class HomeController extends Controller
{
    private $request;

    public function __construct(Request $request)
    {        
        $this->request = $request;
    }

    public function index(Request $request)
    {
        
        return view('seller::frontend.home.index', []);
    }

    public function signup(Request $request) {
        return view('seller::frontend.home.register', []);
    }

    public function register(Request $request) {
        $user = $this->buildData($request->all());
        $this->validate($this->request, [
            'password'  => 'required',
            'shop_name' => 'required',
            'email' => 'required'
        ]);

        if(!UserSeller::existsUser($request->input('shop_name'), $request->input('email'))) {
            $user = $this->buildData($request->all());
            $status = $user->save();
            if($status) {
               $result['status'] = 'successful';
            } else {
                $result['status'] = 'fail';
                $result['message'] = __('Create account error. Please try again!');
            }
        } else {
            $result['status'] = 'fail';
            $result['message'] = __('Shop name or email exists. Please try again!');
        }
        return response()->json($result);
    }

    private function buildData($filter = []) {
        $user = new UserSeller;
        if(!empty($filter['shop_name'])) {
            $user->shop_name = $filter['shop_name'];
        }
        if(!empty($filter['password'])) {
            $user->password = Hash::make($filter['password']);
        }
        if(!empty($filter['email'])) {
            $user->email = $filter['email'];
        }
        if(!empty($filter['is_receive_artist_new'])) {
            $user->is_receive_artist_new = $filter['is_receive_artist_new'];
        }
        $locate = env('APP_LOCALE');
        if ($locate && $locate != '' && $locate != null) {
            $user->locale = $locate;
        } else {
            $user->locale = "us";
        }
        $user->status = 'inactive';
        return $user;
    }

    public function sync(Request $request) {
        $input = $request->all();
        $response = [
            'status' => 'fail'
        ];
        if (isset($input['seller_token']) && $input['seller_token'] != '') {
            $input['token'] = $input['seller_token'];
            $userToken = User::where('seller_token', '=', $input['seller_token'])
                                ->exists();
            if (!$userToken) {
                $userEmail = User::where('email', '=', $input['email'])->exists();
                if (!$userEmail) {
                    $input['role'] = 'SELLER';
                    User::create($input);
                } else {
                    if (isset($input['password'])) {
                        unset($input['password']);
                    }
                    User::where('email', '=', $input['email'])
                            ->update($input);
                }
            } else {
                User::where('seller_token', '=', $input['seller_token'])
                            ->update($input);
            }
            
            $response['status'] = 'successful';
        }
        return response()->json($response);
    }
}
