<?php

namespace Modules\Seller\Controllers;

use Illuminate\Http\Request;
use Modules\Seller\Controllers\Controller;
use DB;
use Modules\Seller\Models\ProductNUser;
use Modules\Seller\Models\User;

class SellerController extends Controller
{
    public function findFakeSellers ()
    {
        $retVal = [
            'status' => 'fail',
            'result' => []
        ];
        $sellers = User::where('role', 'SELLER')
            ->where(function ($query) {
                $query->where('email', '=', Null)
                    ->orWhere('seller_token', '=', Null);
            })
            ->get(['id', 'name', 'slug', 'email' ]);
        if ($sellers) {
            $retVal['result'] = $sellers;
            $retVal['status'] = 'successful';
        }
        return response()->json($retVal);
    }

    public function removeFakeSeller (REquest $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => [
                'product_ids' => []
            ]
        ];
        $fakeSellerId = $request->get('id');
        $productIds = ProductNUser::where('user_id', $fakeSellerId)->pluck('product_id')->toArray();
        if (User::where('id', $fakeSellerId)->first()->delete()) {
            $retVal['result'] = [
                'product_ids' => $productIds
            ];
            $retVal['status'] = 'successful'; 
        }
        return $retVal;        
    }

    public function getProductIdsOfSeller (Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' =>  [],
        ];
        $fakeSellerId = $request->get('id');
        $productIds = ProductNUser::where('user_id', $fakeSellerId)->pluck('product_id')->toArray();
        if (count($productIds)) {
            $retVal['result'] = $productIds;
        }
        $retVal['status'] = 'successful';
        return $retVal;  
    }
    
}
