<?php

namespace Modules\Seller\Controllers\System;

use DB;
use Illuminate\Http\Request;
use Modules\Seller\Models\User;
use Modules\Seller\Models\ProductMeta;
use Modules\Seller\Models\ProductNDesign;
use Modules\Seller\Controllers\Controller;

class CronController extends Controller {
    public function remapSellerProduct(Request $request) {
        set_time_limit(3600);
        if (!$request->get('token') || $request->get('token') !== config('seller::sa.api_service_token')) {
            return [
                'status' => 'fail',
                'message' => 'Token mismatch'
            ];
        }
        $productLimit = $request->get('product_limit', 5000);
        $sellerLimit = $request->get('seller_limit', 200);
        $designLimit = $request->get('design_limit', 500);

        $sellerIds = User::where('status', 'ACTIVE')
            ->whereNull('seller_token')
            ->get(['id'])->pluck('id');
        $pnU = DB::table('product_n_user')->select('user_id', DB::raw('count(*) as count'))
            ->whereIn('user_id', $sellerIds)
            ->groupBy('user_id')
            ->orderBy('count', 'asc')
            ->get();
        $overLimitSellers = [];
        $belowLimitSellers = [];
        $updateData = [];
        foreach ($pnU as $item) {
            if ($item->count > $productLimit) {
                $overLimitSellers[] = $item;
            } else if ($item->count < $productLimit) {
                $belowLimitSellers[] = $item;
            }
        }
        $belowLimitSellers = array_splice($belowLimitSellers, 0, $sellerLimit);
        if (!empty($belowLimitSellers)) {
            foreach ($overLimitSellers as $item) {
                $diff = $item->count - $productLimit;
                $productIds = DB::table('product_n_user')
                    ->where('product_id', $item->product_id)
                    ->orderBy('id', 'desc')
                    ->limit($diff)
                    ->get(['product_id'])
                    ->pluck('product_id')
                    ->toArray();
                foreach (array_chunk($productIds, 500) as $partProductIds) {
                    $designIds = ProductNDesign::whereIn('product_id', $partProductIds)
                        ->get(['design_id'])
                        ->pluck('design_id')
                        ->toArray();
                    $haveDesignIds = ProductNDesign::whereIn('product_id', $partProductIds)
                        ->get(['product_id'])
                        ->pluck('product_id')
                        ->toArray();
                    $notHaveDesignIds = array_diff($partProductIds, $haveDesignIds);
                    $designIds = array_splice($designIds, 0, $designLimit);
                    $belowLimitSellersIndex = 0;
                    foreach ($designIds as $designId) {
                        if (!isset($belowLimitSellers[$belowLimitSellersIndex])) {
                            $belowLimitSellersIndex = 0;
                        }
                        $seller = $belowLimitSellers[$belowLimitSellersIndex];
                        $updateIds = ProductNDesign::where('design_id', $designId)
                            ->get(['product_id'])
                            ->pluck('product_id')
                            ->toArray();
                        if (!isset($updateData[$seller->value])) {
                            $updateData[$seller->value] = [];
                        }
                        $updateData[$seller->value] = array_merge($updateData[$seller->value], $updateIds);
                        $belowLimitSellersIndex++;
                    }
                    $belowLimitSellersIndex = 0;
                    foreach ($notHaveDesignIds as $productId) {
                        if (!isset($belowLimitSellers[$belowLimitSellersIndex])) {
                            $belowLimitSellersIndex = 0;
                        }
                        $seller = $belowLimitSellers[$belowLimitSellersIndex];
                        if (!isset($updateData[$seller->value])) {
                            $updateData[$seller->value] = [];
                        }
                        $updateData[$seller->value][] = $productId;
    
                        $belowLimitSellersIndex++;
                    }
                }
            }
        }

        foreach ($updateData as $sellerId => $productIds) {
            ProductMeta::whereIn('product_id', $productIds)
                ->where('key', 'user_id')
                ->update([
                    'value' => $sellerId
                ]);
            \DB::table('product_n_user')
                ->whereIn('product_id', $productIds)
                ->update([
                    'user_id' => $sellerId
                ]);
        }
        
        return [
            'status' => 'successful',
            'result' => $updateData
        ];
    }

    public function rebuildProductNSeller(Request $request) {
        set_time_limit(5 * 3600);
        $step = 100000;
        $fromId = 0;
        $toId = $fromId + $step;

        $response = [
            'status' => 'successful',
            'result' => [
                'create' => 0,
                'update' => 0
            ]
        ];

        $bigestId = ProductMeta::orderBy('id', 'desc')->first();

        while($fromId <= $bigestId->id) {
            $metas = ProductMeta::where('key', 'user_id')
                ->where('id', '>=', $fromId)
                ->where('id', '<=', $toId)
                ->get();

            $uniqueMetas = [];

            foreach ($metas as $key => $value) {
                $uniqueMetas[$value->product_id] = $value;
            }

    
            $insertData = [];
            $updateData = [];
            foreach ($uniqueMetas as $key => $value) {
                $first = \DB::table('product_n_user')
                    ->where('product_id', $value->product_id)
                    ->first();
                if (!$first) {
                    $insertData[] = [
                        'product_id' => $value->product_id,
                        'user_id' => $value->value,
                        'created_at' => date('Y-m-d H:i:s', time()),
                        'updated_at' => date('Y-m-d H:i:s', time())
                    ];

                } else if ($first->user_id != $value->value) {
                    $updateData[] = [
                        'id' => $first->id,
                        'user_id' => $value->value
                    ];
                }
            }
    
            foreach (array_chunk($insertData, 200) as $partData) {
                \DB::table('product_n_user')->insert($partData);
            }

            foreach (array_chunk($updateData, 100) as $partData) {
                $updateSql = 'UPDATE sb_product_n_user `pu` join (';
                foreach ($partData as $key => $item) {
                    if ($key == 0) {
                        $updateSql .= ('SELECT ' . $item['id'] . " as `id`, '" . $item['user_id'] . "' as `new_user_id` ");
                    } else {
                        $updateSql .= ('UNION ALL SELECT ' . $item['id'] . " , '" . $item['user_id'] . "' ");
                    }
                }

                $updateSql .= ' ) `values` ON `pu`.id = `values`.id SET `user_id` = `new_user_id`';
                DB::statement($updateSql);
            }

            $response['result']['create'] += count($insertData);
            $response['result']['update'] += count($updateData);

            $fromId = $toId + 1;
            $toId += $step;
        }

        return $response;
    }

    public function rebuildWrongProductNSeller(Request $request) {
        set_time_limit(3600);
        $actorIds = DB::table('users')->where('role', 'SELLER')->whereNotNull('seller_token')->get(['id'])->pluck('id');
        $query = DB::table('product')
            ->join('product_n_user', 'product.id', 'product_n_user.product_id')
            ->where('product.actor_id', '!=', 'product_n_user.user_id')
            ->select(['product_n_user.id', 'product.actor_id', 'product_n_user.user_id']);
        $cloneQuery = clone $query;
        $rows = $cloneQuery->whereIn('product.actor_id', $actorIds)
            ->get()
            ->toArray();
        $staffRows = $query->whereNotIn('product.actor_id', $actorIds)
            ->whereIn('product_n_user.user_id', $actorIds)
            ->get()
            ->toArray();
        $rows = array_merge($rows, $staffRows);
        if($request->get('is_update')) {
            foreach (array_chunk($rows, 100) as $partData) {
                $updateSql = 'UPDATE sb_product_n_user `pu` join (';
                foreach ($partData as $key => $item) {
                    $item = (array)$item;
                    if ($key == 0) {
                        $updateSql .= ('SELECT ' . $item['id'] . " as `id`, '" . $item['actor_id'] . "' as `new_user_id` ");
                    } else {
                        $updateSql .= ('UNION ALL SELECT ' . $item['id'] . " , '" . $item['actor_id'] . "' ");
                    }
                }
    
                $updateSql .= ' ) `values` ON `pu`.id = `values`.id SET `user_id` = `new_user_id`';
                DB::statement($updateSql);
            }
        }
        
        return [
            'status' => 'successful',
            'result' => $rows
        ];
    }
}