<?php 

namespace Modules\Seller\Controllers\System;

use Illuminate\Support\Facades\DB;
use Modules\Seller\Controllers\Controller;
use Illuminate\Http\Request;


class RevenueController extends Controller {
    
    public function statistic (Request $request) {
        $response = [
            'status' => 'fail',
            'result' => [],
        ];
        $url = config('sa.seller_url') . '/api/revenue/statistic';
        $filter = $this->buildFilter($request);
        $filter['auth_key'] = config('sa.seller_auth_key', '');
        $response = $this->triggerAsyncRequest($url, 'POST', $filter);
        if (!empty($response['result'])) {
            $sellerTokens = array_column($response['result'], 'seller_token');
            $sellers = \DB::table('users')->whereIn('seller_token', $sellerTokens)->pluck('email', 'seller_token');
            foreach ($response['result'] as $key => $value) {
                $response['result'][$key]['email'] = $sellers[$key] ?? 'abc';
            }
        }
        return response()->json($response);
    }

    public function statisticRevenueBySeller(Request $request, $sellerToken) {
        $response = [
            'status' => 'fail',
            'result' => [],
        ];
        $url = config('sa.seller_url') . '/api/revenue/get-by-seller';
        $filter = $this->buildFilter($request);
        $filter['seller_token'] = $sellerToken;
        $filter['auth_key'] = config('sa.seller_auth_key', '');
        $response = $this->triggerAsyncRequest($url, 'POST', $filter);
        if (!empty($response['result'])) {
            $productIds = array_column($response['result'], 'product_id');
            $products = \DB::table('product')->whereIn('id', $productIds)->pluck('name', 'id');
            $orderIds = array_column($response['result'], 'order_id');
            $orders = \DB::table('order')->whereIn('id', $orderIds)->pluck('code', 'id');
            foreach ($response['result'] as $key => $item) {
                $response['result'][$key]['product_name'] = $products[$item['product_id']] ?? '-';
                $response['result'][$key]['order_code'] = $orders[$item['order_id']] ?? '-';
            }
        }
        return response()->json($response);
    }

    private function getDateRange($dateFrom, $dateTo) {
        $dateFrom = new \DateTime($dateFrom);
        $dateTo = new \DateTime($dateTo . '23:59:59');
        $dateRange = [];
        $interval = new \DateInterval('P1D');
        $dateRange = new \DatePeriod($dateFrom, $interval, $dateTo);
        $dateRange = collect($dateRange)->map(function ($date) {
            return $date->format('Y-m-d');
        });
        return $dateRange;
    }

    private function buildMetaData($items, $filter) {

        $totalCount = $items->count();
        $pageCount = ceil($totalCount / 20);
        $pageId = $filter['page_id'];
        $hasNext = $pageId < $pageCount;
        return [
            'total_count' => $totalCount,
            'page_id' => $pageId - 1,
            'page_size' => 20,
            'page_count' => $pageCount,
            'has_next' => $hasNext,
        ];
    }
   
    private function buildFilter($request) {
        $filter = [];
        if (empty($request->input('dateFrom'))) {
            $filter['dateFrom'] = date('Y-m-d', strtotime('-6 days'));
        } else {
            $filter['dateFrom'] = date('Y-m-d', strtotime(str_replace('/', '-', $request->input('dateFrom'))));
        }
        if (empty($request->input('dateTo'))) {
            $filter['dateTo'] = date('Y-m-d');
        } else {
            $filter['dateTo'] = date('Y-m-d', strtotime(str_replace('/', '-', $request->input('dateTo'))));
        }
        $filter['email'] = $request->input('email');
        $filter['page_id'] = (int) $request->input('page_id') ?? 1;
        if (!empty($request->input('status')) && $request->input('status') != 'null' && $request->input('status') != 'all') {
            $filter['status'] = $request->input('status');
        }
        return $filter;
    }

  
}
