<?php 

namespace Modules\Seller\Controllers\System;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Modules\Seller\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Modules\Seller\Controllers\Service\RevenueController;

class SellerReportController extends Controller {
    
    public function __construct(RevenueController $revenueController) {
        $this->revenueController = $revenueController;
    }

    public function countSellerCreatedProduct(Request $request)
    {
        $dateFrom = $request->input('dateFrom');
        $dateTo = $request->input('dateTo');

        $query = DB::table('users')
            ->whereNotNull('users.seller_token')
            ->join('product_n_user', 'product_n_user.user_id', 'users.id')
            ->join('product', 'product.id', 'product_n_user.product_id')
            ->where('product.status', 'active')
            ->select('users.name', 'product_n_user.user_id', DB::raw('count(*) as total'))
            ->groupBy('product_n_user.user_id')
            ->orderBy('total', 'desc');

        if ($dateFrom) $query->where('product_n_user.created_at', '>=', $dateFrom);
        if ($dateTo) $query->where('product_n_user.created_at', '<=', $dateFrom);

        return $query->get();
    }

    public function listSellerProductCreatedCount()
    {
        return view('seller::system.report.seller-product-count');
    }

    public function getReportByProduct(Request $request)
    {
        $params = [
            'page_id' => $request->input('page_id'),
            'page_size' => $request->input('page_size'),
            'key_word' => $request->input('key_word'),
            'start_date' => $request->input('start_date'),
            'end_date' => $request->input('end_date'),
        ];

        $seller = DB::table('users')
        ->whereNotNull('seller_token')
        ->where('seller_token', $request->input('seller_token'))->first();
        
        $resultReport = [];

        if ($seller) {
            $resultReport = $this->getStatisticRevenueByProduct($seller->id, $params);
        }

        $retval = [
            'status' => 'successful',
            'result' => $resultReport
        ];

        return response()->json($retval);
    }

    public function getStatisticRevenueByProduct($sellerId, $data)
    {
        $paginate = $this->customizePaginate($sellerId, $data);

        $metaData = [
            'total_count' => $paginate->total(),
            'page_count' => $paginate->lastPage(),
            'page_id' => $paginate->currentPage() - 1 ?? 0,
            'page_size' => intval($data['page_size']) ?? 20,
            'off_set' => 0,
            'has_next' => $paginate->currentPage() < $paginate->lastPage(),
        ];

        return ['dataPaginate' => $paginate, 'metaData' => $metaData];
    }

    public function statisticRevenueByProduct($sellerId, $data)
    {
        $query = DB::table('order_item')
            ->join('order','order_item.order_id','=','order.id')
            ->join('product', 'product.id', '=', 'order_item.product_id')
            ->join('product_n_user as pnu', 'pnu.product_id', '=', 'order_item.product_id')
            ->where('pnu.user_id', $sellerId)
            ->where('order.payment_status', 'PAID');

        if ($data['key_word']) {
            $query = $query->where(function ($q) use ($data) {
                return $q->where('product.sku', 'like', "%{$data['key_word']}%")
                    ->orWhere('product.name', 'like', "%{$data['key_word']}%");
            });
        }

        if ($data['start_date'] && $data['start_date'] != "undefined") {
            $query = $query->where('order.created_at', '>=', new Carbon(str_replace('/', '-', $data['start_date'])));
        }
        if ($data['end_date'] && $data['end_date'] != "undefined") {
            $query = $query->where('order.created_at', '<=', new Carbon(str_replace('/', '-', $data['end_date']) . ' 23:59:59'));
        }

        return $query->select([
            'order_item.product_id',
            'product.sku',
            'product.image_url',
            'product.name',
            'order_item.product_id',
            DB::raw('SUM(sb_order_item.quantity) as total_sale'),
            DB::raw('SUM((sb_order_item.quantity * sb_order_item.price)) as total_revenue')
        ])
            ->groupBy('order_item.product_id')
            ->get();
    }

    // public function getCommission($sellerId){
    //     $result = DB::table('order_item')
    //     ->join('order','order_item.order_id','=','order.id')
    //     ->where('order.payment_status', 'PAID')
    //     ->where('order.status', 'FINISHED')
    //     ->where('order_item.seller_id', $sellerId)
    //     ->select([
    //         'order_item.product_id',
    //         'order_item.product_sku_id',
    //         'order_item.quantity',
    //         'order_item.price',
    //     ])->get();

    //     $data = [];

    //     foreach ($result as $item) {
    //         if (isset($data[$item->product_id])) {
    //             $data[$item->product_id] += $this->revenueController->calculatePayment((array) $item);
    //         } else {
    //             $data[$item->product_id] = $this->revenueController->calculatePayment((array) $item);
    //         }
    //     }

    //     return $data;
    // }

    public function customizePaginate($sellerId, $data)
    {
        $result = $this->statisticRevenueByProduct($sellerId, $data);

        $data = new LengthAwarePaginator(
            $result->forPage($data['page_id'] + 1, $data['page_size']),
            $result->count(),
            $data['page_size'],
            $data['page_id'] + 1
        );

        return $data;
    }
}
