<?php 

namespace Modules\Seller\Controllers\System;

use Illuminate\Support\Facades\DB;
use Modules\Seller\Controllers\Controller;
use Illuminate\Http\Request;


class SellerStatisticController extends Controller {
    
    public function newProductEveryDay (Request $request) {
        $filter = $this->buildFilter($request);
        $query = DB::table('seller_statistic_date as ssd')
                ->join('users', 'users.id', '=', 'ssd.user_id')
                ->where('ssd.type', 'NEW_PRODUCT');
        if ($filter['dateFrom']) {
            $query->where('ssd.date', '>=', $filter['dateFrom']);
        }
        if ($filter['dateTo']) {
            $query->where('ssd.date', '<=', $filter['dateTo']);
        }
        if (!empty($filter['email'])) {
            $query->where('users.email', 'like', '%' . $filter['email'] . '%');
        }
        $dateRange = $this->getDateRange($filter['dateFrom'], $filter['dateTo']);
        $items = $query->select('ssd.date', 'users.email', 'ssd.value', 'users.name', 'ssd.user_id')->get();
        $productBySeller = [];
        $meta = [];
        if (!empty($items)) {
            foreach ($items as $item) {
                if (!isset($productBySeller[$item->user_id])) {
                    $productBySeller[$item->user_id] = [
                        'email' => $item->email,
                        'name' => $item->name,
                        'total' => 0,
                        'dates' => []
                    ];
                }
                $productBySeller[$item->user_id]['total'] += $item->value;
                $productBySeller[$item->user_id]['dates'][$item->date] = $item->value;
            }
            $productBySeller = collect($productBySeller)->sortByDesc('total')->values();
            $meta = $this->buildMetaData($productBySeller, $filter);
            $retval = $productBySeller->forPage($filter['page_id'], 20);
        }

        return [
            'status' => 'success',
            'result' => $retval,
            'dates' => $dateRange,
            'meta' => $meta
        ];
    }

    private function getDateRange($dateFrom, $dateTo) {
        $dateFrom = new \DateTime($dateFrom);
        $dateTo = new \DateTime($dateTo . '23:59:59');
        $dateRange = [];
        $interval = new \DateInterval('P1D');
        $dateRange = new \DatePeriod($dateFrom, $interval, $dateTo);
        $dateRange = collect($dateRange)->map(function ($date) {
            return $date->format('Y-m-d');
        });
        return $dateRange;
    }

    private function buildMetaData($items, $filter) {

        $totalCount = $items->count();
        $pageCount = ceil($totalCount / 20);
        $pageId = $filter['page_id'];
        $hasNext = $pageId < $pageCount;
        return [
            'total_count' => $totalCount,
            'page_id' => $pageId - 1,
            'page_size' => 20,
            'page_count' => $pageCount,
            'has_next' => $hasNext,
        ];
    }
   
    private function buildFilter($request) {
        $filter = [];
        if (empty($request->input('dateFrom'))) {
            $filter['dateFrom'] = date('Y-m-d', strtotime('-6 days'));
        } else {
            $filter['dateFrom'] = date('Y-m-d', strtotime(str_replace('/', '-', $request->input('dateFrom'))));
        }
        if (empty($request->input('dateTo'))) {
            $filter['dateTo'] = date('Y-m-d');
        } else {
            $filter['dateTo'] = date('Y-m-d', strtotime(str_replace('/', '-', $request->input('dateTo'))));
        }
        $filter['email'] = $request->input('email');
        $filter['page_id'] = (int) $request->input('page_id') ?? 1;
        return $filter;
    }

  
}
