<?php

namespace Modules\Seller\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Seller\Models\ProductMeta;

class Product extends Model
{
    use SoftDeletes;

    protected $table = 'product';

    protected $fillable = [
        'sku',
        'barcode',
        'name',
        'slug',
        'image_url',
        'price',
        'high_price',
        'add_shipping_fee',
        'weight',
        'status',
        'description',
        'content',
        'note',
        'inventory',
        'brand_id',
        'status_out_stock',
        'pod_parent_id',
        "approve_advertising",
        'created_at',
        'updated_at',
        'gtin'
    ];

    public function galleries()
    {
        return $this->hasMany(ProductGallery::class, 'product_id', 'id')->where('type', 'PRODUCT');
    }

    public function meta()
    {
        return $this->hasMany(ProductMeta::class, 'product_id', 'id');
    }

    public function productSkus()
    {
        return $this->hasMany(ProductSku::class, 'product_id', 'id');
    }

    public function approveAdvertisings()
    {
        return $this->hasMany(ApproveAdvertising::class, 'product_id', 'id');
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'product_n_category')->withPivot(['sorder'])->withTimestamps();
    }

    public function baseCategories()
    {
        return $this->belongsToMany(Category::class, 'product_n_category')->withPivot(['sorder'])->withTimestamps();
    }

    public function tags() {
        return $this->belongsToMany('\Modules\Seller\Models\Tag', 'tag_refer' ,'refer_id', 'tag_id')->where('refer_type', TagRefer::REFER_PRODUCT);
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function filterValues()
    {
        return $this->belongsToMany(FilterValue::class, 'filter_value_n_product');
    }

    public function productsSku(){
        return $this->hasMany(ProductSku::class, 'product_id');
    }

    public function productSku($id){
        return $this->productsSku()->where('id','=', $id);
    }

    public function designs() {
        return $this->belongsToMany(Design::class, 'product_n_design')->withPivot('is_primary');
    }

    public function primaryDesigns() {
        return $this->designs()->wherePivot('is_primary', '1');
    }
}
